/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.gui.chooser.AbstractExtensionFileFilterFileChooser;
import adams.gui.core.ExtensionFileFilter;
import java.io.File;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;

public class ImageFileChooser
extends AbstractExtensionFileFilterFileChooser<ExtensionFileFilter> {
    private static final long serialVersionUID = -4519042048473978377L;
    protected static Hashtable<String, ImageFormat> m_ImageReaders;
    protected static Hashtable<String, ImageFormat> m_ImageWriters;

    public ImageFileChooser() {
    }

    public ImageFileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
    }

    public ImageFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    @Override
    protected Vector<ExtensionFileFilter> getOpenFileFilters() {
        Vector<ExtensionFileFilter> result = new Vector<ExtensionFileFilter>();
        Vector<String> keys = new Vector<String>(m_ImageReaders.keySet());
        for (String key : keys) {
            ImageFormat format = m_ImageReaders.get(key);
            result.add(new ExtensionFileFilter(format.getDisplayName(), format.getExtensions().toArray(new String[0])));
        }
        Collections.sort(result);
        return result;
    }

    @Override
    protected Vector<ExtensionFileFilter> getSaveFileFilters() {
        Vector<ExtensionFileFilter> result = new Vector<ExtensionFileFilter>();
        Vector<String> keys = new Vector<String>(m_ImageWriters.keySet());
        for (String key : keys) {
            ImageFormat format = m_ImageWriters.get(key);
            result.add(new ExtensionFileFilter(format.getDisplayName(), format.getExtensions().toArray(new String[0])));
        }
        Collections.sort(result);
        return result;
    }

    @Override
    protected void updateCurrentHandlerHook() {
        try {
            Object newHandler = null;
            String suffix = ((ExtensionFileFilter)this.getFileFilter()).getExtensions()[0];
            Iterator<Object> iter = this.m_DialogType == 1 ? ImageIO.getImageReadersBySuffix(suffix) : ImageIO.getImageWritersBySuffix(suffix);
            if (iter.hasNext()) {
                newHandler = iter.next();
            }
            if (newHandler == null) {
                return;
            }
            if (this.m_CurrentHandler == null) {
                this.m_CurrentHandler = newHandler;
            } else if (!this.m_CurrentHandler.getClass().equals(newHandler.getClass())) {
                this.m_CurrentHandler = newHandler;
            }
        }
        catch (Exception e) {
            this.m_CurrentHandler = null;
            e.printStackTrace();
        }
    }

    public ImageReader getImageReader() {
        this.configureCurrentHandlerHook(1);
        if (this.m_CurrentHandler instanceof ImageReader) {
            return (ImageReader)this.m_CurrentHandler;
        }
        return null;
    }

    public ImageWriter getImageWriter() {
        this.configureCurrentHandlerHook(1);
        if (this.m_CurrentHandler instanceof ImageWriter) {
            return (ImageWriter)this.m_CurrentHandler;
        }
        return null;
    }

    @Override
    protected boolean getFiltersInitialized() {
        return m_ImageReaders != null;
    }

    @Override
    protected void doInitializeFilters() {
        int i;
        m_ImageReaders = new Hashtable();
        m_ImageWriters = new Hashtable();
        String[] suffixes = ImageIO.getReaderFileSuffixes();
        for (i = 0; i < suffixes.length; ++i) {
            Iterator<ImageReader> readers = ImageIO.getImageReadersBySuffix(suffixes[i]);
            while (readers.hasNext()) {
                ImageReader reader = readers.next();
                try {
                    String formatName = reader.getFormatName();
                    if (!m_ImageReaders.containsKey(formatName)) {
                        m_ImageReaders.put(formatName, new ImageFormat(formatName));
                    }
                    m_ImageReaders.get(formatName).addExtension(suffixes[i]);
                }
                catch (Exception e) {}
            }
        }
        suffixes = ImageIO.getWriterFileSuffixes();
        for (i = 0; i < suffixes.length; ++i) {
            String formatName = ImageFileChooser.getReaderFormatName(suffixes[i]);
            if (formatName == null) continue;
            if (!m_ImageWriters.containsKey(formatName)) {
                m_ImageWriters.put(formatName, new ImageFormat(formatName));
            }
            m_ImageWriters.get(formatName).addExtension(suffixes[i]);
        }
    }

    public static String getReaderFormatName(File file) {
        return ImageFileChooser.getReaderFormatName(file.getName().replaceAll(".*\\.", ""));
    }

    public static String getReaderFormatName(String suffix) {
        String result = null;
        for (String format : m_ImageReaders.keySet()) {
            Vector<String> exts = m_ImageReaders.get(format).getExtensions();
            for (String ext : exts) {
                if (!ext.equals(suffix)) continue;
                result = format;
                break;
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    public static String getWriterFormatName(File file) {
        return ImageFileChooser.getWriterFormatName(file.getName().replaceAll(".*\\.", ""));
    }

    public static String getWriterFormatName(String suffix) {
        String result = null;
        for (String format : m_ImageWriters.keySet()) {
            Vector<String> exts = m_ImageWriters.get(format).getExtensions();
            for (String ext : exts) {
                if (!ext.equals(suffix)) continue;
                result = format;
                break;
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    public static class ImageFormat
    implements Comparable<ImageFormat> {
        protected String m_FormatName;
        protected String m_DisplayName;
        protected Vector<String> m_Extensions;

        public ImageFormat(String format) {
            this(format, format.toUpperCase() + " image");
        }

        public ImageFormat(String format, String display) {
            this.m_FormatName = format;
            this.m_DisplayName = display;
            this.m_Extensions = new Vector();
        }

        public String getFormatName() {
            return this.m_FormatName;
        }

        public String getDisplayName() {
            return this.m_DisplayName;
        }

        public void addExtension(String value) {
            if (!this.m_Extensions.contains(value)) {
                this.m_Extensions.add(value);
                Collections.sort(this.m_Extensions);
            }
        }

        public Vector<String> getExtensions() {
            return this.m_Extensions;
        }

        @Override
        public int compareTo(ImageFormat o) {
            return this.m_FormatName.toLowerCase().compareTo(o.getFormatName().toLowerCase());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ImageFormat)) {
                return false;
            }
            return this.compareTo((ImageFormat)obj) == 0;
        }

        public String toString() {
            return "format=" + this.getFormatName() + ", " + "display=" + this.getDisplayName() + ", " + "ext=" + this.getExtensions();
        }
    }
}

