/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ConsoleObject.java
 * Copyright (C) 2009-2011 University of Waikato, Hamilton, New Zealand
 */

package adams.core;

import java.io.Serializable;

import adams.core.PrintObject.OutputType;

/**
 * A basic object, defining println methods for System.err and System.out.
 * Outputs the classname and the hashcode of the object before the actual
 * output, in order to identify object output in a parallel-executed
 * environment.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public class ConsoleObject
  implements Serializable, SizeOfHandler {

  /** for serialization. */
  private static final long serialVersionUID = -1751927627991692869L;

  /** the object for printing to stdout. */
  private PrintObject m_SystemOut = new PrintObject(this, OutputType.STDOUT, true, null);

  /** the object for printing to stderr. */
  private PrintObject m_SystemErr = new PrintObject(this, OutputType.STDERR, true, null);

  /** the object for debugging output. */
  private PrintObject m_Debugging = new PrintObject(this, OutputType.DEBUG, false, null);

  /**
   * Returns the Debugging print object.
   *
   * @return		the print object
   */
  public PrintObject getDebugging() {
    return m_Debugging;
  }

  /**
   * Returns the SystemOut print object.
   *
   * @return		the print object
   */
  public PrintObject getSystemOut() {
    return m_SystemOut;
  }

  /**
   * Returns the SystemErr print object.
   *
   * @return		the print object
   */
  public PrintObject getSystemErr() {
    return m_SystemErr;
  }

  /**
   * Returns the size of the object.
   *
   * @return		the size of the object
   */
  public int sizeOf() {
    return SizeOf.sizeOf(this);
  }
}
