/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.BaseObject;
import adams.test.AdamsTestCase;

public abstract class AbstractBaseObjectTestCase<T extends BaseObject>
extends AdamsTestCase {
    public AbstractBaseObjectTestCase(String name) {
        super(name);
    }

    protected abstract T getDefault();

    protected String getDefaultValue() {
        return this.getDefault().getValue();
    }

    protected abstract T getCustom(String var1);

    public void testCompareDefault() {
        T defObj1 = this.getDefault();
        T defObj2 = this.getDefault();
        AbstractBaseObjectTestCase.assertEquals((String)"objects not equal (equals)", defObj1, defObj2);
        AbstractBaseObjectTestCase.assertTrue((String)"objects not equal (compareTo != 0)", (defObj1.compareTo(defObj2) == 0 ? 1 : 0) != 0);
    }

    public void testCompareDefaultAndCustom() {
        T defObj = this.getDefault();
        T custObj = this.getCustom(defObj.getValue());
        AbstractBaseObjectTestCase.assertEquals((String)"objects not equal (equals)", defObj, custObj);
        AbstractBaseObjectTestCase.assertTrue((String)"objects not equal (compareTo != 0)", (defObj.compareTo(custObj) == 0 ? 1 : 0) != 0);
    }

    public void testDefault() {
        T defObj = this.getDefault();
        T custObj = this.getCustom(defObj.getValue());
        AbstractBaseObjectTestCase.assertEquals((String)"parsed values differ", (String)defObj.getValue(), (String)custObj.getValue());
    }

    protected abstract String getTypicalValue();

    public void testTypicalValue() {
        try {
            T b = this.getCustom(this.getTypicalValue());
            AbstractBaseObjectTestCase.assertEquals((String)"values differ", (String)this.getTypicalValue(), (String)b.getValue());
        }
        catch (Exception e) {
            AbstractBaseObjectTestCase.fail((String)("Parsing failed: " + e));
        }
    }
}

