/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOptionProducerTestCase;
import adams.core.option.FlowStructureDotProducer;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.LowerCase;
import adams.flow.control.Flow;
import adams.flow.control.Tee;
import adams.flow.core.AbstractActor;
import adams.flow.sink.Display;
import adams.flow.sink.DumpFile;
import adams.flow.sink.Null;
import adams.flow.source.SingleFileSupplier;
import adams.flow.transformer.Convert;
import adams.flow.transformer.TextFileReader;

public class FlowStructureDotProducerTest
extends AbstractOptionProducerTestCase {
    public FlowStructureDotProducerTest(String name) {
        super(name);
    }

    public void testSimple() {
        DumpFile handler = new DumpFile();
        handler.setDebugLevel(1);
        handler.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.csv"));
        handler.setAppend(true);
        FlowStructureDotProducer producer = new FlowStructureDotProducer();
        producer.produce((OptionHandler)handler);
        FlowStructureDotProducerTest.assertEquals((String)"getOutput() differs", (String)"digraph adams_flow_sink_DumpFile {\n  N1 [label=\"DumpFile\" shape=box]\n}\n", (String)("" + producer.getOutput()));
        FlowStructureDotProducerTest.assertEquals((String)"toString() differs", (String)("" + producer.getOutput()), (String)producer.toString());
    }

    public void testComplex() {
        Flow flow = new Flow();
        try {
            AbstractArgumentOption argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("actors");
            AbstractActor[] tmp1 = new AbstractActor[4];
            SingleFileSupplier tmp2 = new SingleFileSupplier();
            argOption = (AbstractArgumentOption)tmp2.getOptionManager().findByProperty("file");
            tmp2.setFile((PlaceholderFile)argOption.valueOf("${CWD}/parsers.xml"));
            tmp1[0] = tmp2;
            TextFileReader tmp4 = new TextFileReader();
            argOption = (AbstractArgumentOption)tmp4.getOptionManager().findByProperty("outputType");
            tmp4.setOutputType((TextFileReader.OutputType)argOption.valueOf("SINGLE_STRING"));
            tmp1[1] = tmp4;
            Tee tmp6 = new Tee();
            argOption = (AbstractArgumentOption)tmp6.getOptionManager().findByProperty("actors");
            AbstractActor[] tmp7 = new AbstractActor[2];
            Convert tmp8 = new Convert();
            argOption = (AbstractArgumentOption)tmp8.getOptionManager().findByProperty("conversion");
            LowerCase tmp10 = new LowerCase();
            tmp8.setConversion((AbstractConversion)tmp10);
            tmp7[0] = tmp8;
            Null tmp11 = new Null();
            tmp7[1] = tmp11;
            tmp6.setActors(tmp7);
            tmp1[2] = tmp6;
            Display tmp12 = new Display();
            tmp1[3] = tmp12;
            flow.setActors(tmp1);
        }
        catch (Exception e) {
            FlowStructureDotProducerTest.fail((String)("Set up of flow failed: " + e));
        }
        FlowStructureDotProducer producer = new FlowStructureDotProducer();
        producer.produce((OptionHandler)flow);
        FlowStructureDotProducerTest.assertEquals((String)"getOutput() differs", (String)"digraph adams_flow_control_Flow {\n  N1 [label=\"Flow\" shape=ellipse]\n  N1 -> N2\n  N2 [label=\"SingleFileSupplier\" shape=parallelogram]\n  N2 -> N3\n  N3 [label=\"TextFileReader\" shape=box]\n  N3 -> N4\n  N4 [label=\"Tee\" shape=triangle]\n  N4 -> N5\n  N5 [label=\"Convert\" shape=box]\n  N5 -> N6\n  N6 [label=\"Null\" shape=box]\n  N4 -> N7\n  N7 [label=\"Display\" shape=box]\n}\n", (String)("" + producer.getOutput()));
        FlowStructureDotProducerTest.assertEquals((String)"toString() differs", (String)("" + producer.getOutput()), (String)producer.toString());
    }
}

