/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.container.DataContainer;
import adams.data.io.output.AbstractDataContainerWriter;
import adams.test.AbstractDatabaseTestCase;
import adams.test.AbstractTestHelper;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;

public abstract class AbstractDataContainerWriterTestCase<A extends AbstractDataContainerWriter, D extends DataContainer>
extends AbstractDatabaseTestCase {
    public AbstractDataContainerWriterTestCase(String name) {
        super(name);
    }

    @Override
    protected AbstractTestHelper newTestHelper() {
        return new TestHelper(this, "adams/data/io/output/data");
    }

    protected D load(String filename) {
        return (D)this.m_TestHelper.load(filename);
    }

    protected boolean save(D data, A scheme, String filename) {
        TmpFile file = new TmpFile(filename);
        scheme.setOutput((PlaceholderFile)file);
        scheme.write(data);
        return file.exists();
    }

    protected String[] getRegressionConnections() {
        return null;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract A[] getRegressionSetups();

    protected abstract int[] getRegressionIgnoredLineIndices();

    protected String createOutputFilename(String input, int no) {
        String result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
            result = result + input.substring(index);
        }
        return result;
    }

    public void testRegression() {
        int i;
        String[] input = this.getRegressionInputFiles();
        String[] output = new String[input.length];
        AbstractDataContainerWriter[] setups = this.getRegressionSetups();
        int[] ignored = this.getRegressionIgnoredLineIndices();
        String[] props = this.getRegressionConnections();
        AbstractDataContainerWriterTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        if (props != null) {
            AbstractDataContainerWriterTestCase.assertEquals((String)"Number of files and connection setups differ!", (int)input.length, (int)props.length);
        } else {
            props = new String[input.length];
            for (i = 0; i < props.length; ++i) {
                props[i] = this.getDatabasePropertiesFile();
            }
        }
        for (i = 0; i < input.length; ++i) {
            this.reconnect(props[i]);
            AbstractDataContainerWriter current = (AbstractDataContainerWriter)OptionUtils.shallowCopy((OptionHandler)setups[i], (boolean)false);
            AbstractDataContainerWriterTestCase.assertNotNull((String)("Failed to create copy of algorithm: " + OptionUtils.getCommandLine((Object)setups[i])), (Object)current);
            D data = this.load(input[i]);
            AbstractDataContainerWriterTestCase.assertNotNull((String)"Failed to read data?", data);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(data, current, output[i]);
            AbstractDataContainerWriterTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            if (!(current instanceof Destroyable)) continue;
            current.destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles, ignored);
        AbstractDataContainerWriterTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                setups[i].cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
        this.m_Properties = null;
        this.getDatabaseProperties();
    }

    protected void cleanUpAfterRegression() {
    }
}

