/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.io.FileUtils;
import adams.core.option.AbstractOptionProducer;
import adams.core.option.ArrayProducer;
import adams.core.option.NestedProducer;
import adams.core.option.OptionHandler;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.processor.AbstractActorProcessor;
import adams.flow.processor.ModifyingProcessor;
import adams.test.AbstractDatabaseTestCase;
import adams.test.AbstractTestHelper;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;

public abstract class AbstractActorProcessorTestCase
extends AbstractDatabaseTestCase {
    public static final String PROPERTY_DUMPFILE_INPUT = "adams.test.flowprocessor.dump.inputfile";
    public static final String PROPERTY_DUMPFILE_OUTPUT = "adams.test.flowprocessor.dump.outputfile";
    public static final String PROPERTY_APPEND = "adams.test.flowprocessor.dump.append";
    public static final String PROPERTY_FORMAT = "adams.test.flowprocessor.dump.format";
    protected static boolean VERBOSE = false;
    protected AbstractActor m_Actor;

    public AbstractActorProcessorTestCase(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Actor = this.getActor();
        if (this.m_Actor instanceof Flow) {
            ((Flow)this.m_Actor).setErrorHandling(Flow.ErrorHandling.ACTORS_ALWAYS_STOP_ON_ERROR);
        }
    }

    public void runBare() throws Throwable {
        try {
            super.runBare();
        }
        catch (Throwable t) {
            if (this.m_Actor != null) {
                System.out.println(this.dumpActor(this.m_Actor, (AbstractOptionProducer)new NestedProducer()));
            }
            throw t;
        }
        finally {
            if (this.m_Actor != null) {
                this.m_Actor.destroy();
                this.m_Actor = null;
            }
        }
    }

    public abstract AbstractActor getActor();

    protected abstract AbstractActorProcessor[] getRegressionSetups();

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[]{0, 1, 2, 3};
    }

    public void testRegression() {
        String filenameOut;
        boolean append = Boolean.getBoolean(PROPERTY_APPEND);
        String filenameIn = System.getProperty(PROPERTY_DUMPFILE_INPUT);
        if (filenameIn != null && filenameIn.length() == 0 && filenameIn.startsWith("$")) {
            filenameIn = null;
        }
        if ((filenameOut = System.getProperty(PROPERTY_DUMPFILE_OUTPUT)) != null && filenameOut.length() == 0 && filenameOut.startsWith("$")) {
            filenameOut = null;
        }
        AbstractActorProcessor[] setups = this.getRegressionSetups();
        File[] files = new File[setups.length];
        for (int i = 0; i < setups.length; ++i) {
            try {
                ModifyingProcessor modifying;
                AbstractActor input = this.m_Actor.shallowCopy();
                if (filenameIn != null) {
                    this.dumpActor(input, filenameIn, append);
                }
                setups[i].process(input);
                AbstractActor output = input;
                if (setups[i] instanceof ModifyingProcessor && (modifying = (ModifyingProcessor)setups[i]).isModified()) {
                    output = modifying.getModifiedActor();
                }
                if (filenameOut != null) {
                    this.dumpActor(output, filenameOut, append);
                }
                files[i] = new TmpFile("processed-" + (i + 1));
                FileUtils.writeToFile((String)files[i].getAbsolutePath(), (Object)this.dumpActor(output, (AbstractOptionProducer)new NestedProducer()), (boolean)false);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String regression = this.m_Regression.compare(files, this.getRegressionIgnoredLineIndices());
        AbstractActorProcessorTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
    }

    @Override
    protected AbstractTestHelper newTestHelper() {
        return new TestHelper(this, "adams/flow/data");
    }

    protected String dumpActor(AbstractActor actor, AbstractOptionProducer producer) {
        producer.produce((OptionHandler)actor);
        String result = producer.toString();
        producer.cleanUp();
        return result;
    }

    protected boolean dumpActor(AbstractActor actor, String filename, boolean append) {
        String content;
        boolean result;
        String format = System.getProperty(PROPERTY_FORMAT);
        ArrayProducer producer = null;
        if (format != null && format.length() >= 0) {
            try {
                producer = (AbstractOptionProducer)Class.forName(format).newInstance();
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate option producer '" + format + "': " + e);
                producer = null;
            }
        }
        if (producer == null) {
            producer = new ArrayProducer();
        }
        if (result = FileUtils.writeToFile((String)filename, (Object)(content = this.dumpActor(actor, (AbstractOptionProducer)producer)), (boolean)append)) {
            System.out.println(((Object)((Object)this)).getClass().getName() + ": flow " + (append ? "appended" : "saved") + " to " + filename);
        } else {
            System.out.println(((Object)((Object)this)).getClass().getName() + ": failed to " + (append ? "append" : "save") + " flow to " + filename);
        }
        return result;
    }
}

