/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.env.Environment;
import adams.parser.AbstractExpressionEvaluatorTestCase;
import adams.parser.BaseDateTimeExpression;
import adams.parser.BaseTimeExpression;
import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestSuite;

public class BaseTimeExpressionTest
extends AbstractExpressionEvaluatorTestCase<Date, BaseTimeExpression> {
    public BaseTimeExpressionTest(String name) {
        super(name);
    }

    @Override
    protected String[][] getRegressionExpressions() {
        return new String[][]{{"-INF", "+INF", "01:02:03 +1 SECOND", "01:02:03 +1 MINUTE", "01:02:03 +1 HOUR", "01:02:03 -1 SECOND", "01:02:03 -1 MINUTE", "01:02:03 -1 HOUR", "01:02:03", "START +1 HOUR", "END -1 HOUR"}};
    }

    protected BaseTimeExpression[] getRegressionSetups() {
        return new BaseTimeExpression[]{new BaseTimeExpression()};
    }

    public static void testStart() {
        String expr = "START +1 HOUR +1 SECOND";
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        String startStr = "12:34:00";
        Date start = null;
        Date parsed = null;
        try {
            start = format.parse(startStr);
        }
        catch (Exception e) {
            BaseTimeExpressionTest.fail((String)("Failed to generate Date object from '" + startStr + "': " + e));
        }
        try {
            parsed = BaseDateTimeExpression.evaluate((String)expr, (Date)start, null);
        }
        catch (Exception e) {
            BaseTimeExpressionTest.fail((String)("Failed to parse expression '" + expr + "': " + e));
        }
        BaseTimeExpressionTest.assertNotNull((String)"Generated null date", (Object)parsed);
        BaseTimeExpressionTest.assertEquals((String)"Generated different date", (String)"13:34:01", (String)format.format(parsed));
    }

    public static void testEnd() {
        String expr = "END -1 HOUR -1 SECOND";
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        String endStr = "12:34:00";
        Date end = null;
        Date parsed = null;
        try {
            end = format.parse(endStr);
        }
        catch (Exception e) {
            BaseTimeExpressionTest.fail((String)("Failed to generate Date object from '" + endStr + "': " + e));
        }
        try {
            parsed = BaseDateTimeExpression.evaluate((String)expr, null, (Date)end);
        }
        catch (Exception e) {
            BaseTimeExpressionTest.fail((String)("Failed to parse expression '" + expr + "': " + e));
        }
        BaseTimeExpressionTest.assertNotNull((String)"Generated null date", (Object)parsed);
        BaseTimeExpressionTest.assertEquals((String)"Generated different date", (String)"11:33:59", (String)format.format(parsed));
    }

    public static Test suite() {
        return new TestSuite(BaseTimeExpressionTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        BaseTimeExpressionTest.runTest(BaseTimeExpressionTest.suite());
    }
}

