/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.CloneHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class LRUCache<K, V>
implements Serializable,
CloneHandler<LRUCache<K, V>> {
    private static final long serialVersionUID = -4869609636566618142L;
    public static final float HASHTABLE_LOAD_FACTOR = 0.75f;
    protected LinkedHashMap<K, V> m_Map;
    protected int m_CacheSize;
    protected boolean m_Enabled;

    public LRUCache(int cacheSize) {
        this.resize(cacheSize);
    }

    public synchronized boolean isEnabled() {
        return this.m_Enabled;
    }

    public synchronized void setEnabled(boolean value) {
        if (value && this.m_CacheSize > 0 || !value) {
            this.m_Enabled = value;
        }
    }

    public int size() {
        return this.m_CacheSize;
    }

    public synchronized int sizeUsed() {
        return this.m_Map.size();
    }

    public synchronized void resize(int cacheSize) {
        this.m_Enabled = false;
        this.m_CacheSize = cacheSize;
        this.m_Map = new LRUCacheLinkedHashMap((int)Math.ceil((float)cacheSize / 0.75f) + 1, 0.75f);
        this.m_Enabled = this.m_CacheSize > 0;
    }

    public synchronized boolean contains(K key) {
        return this.m_Map.containsKey(key);
    }

    public synchronized V get(K key) {
        return this.m_Map.get(key);
    }

    public synchronized void put(K key, V value) {
        if (this.m_Enabled) {
            this.m_Map.put(key, value);
        }
    }

    public synchronized V remove(K key) {
        if (this.m_Enabled) {
            return this.m_Map.remove(key);
        }
        return null;
    }

    public synchronized void clear() {
        this.m_Map.clear();
    }

    public synchronized Collection<Map.Entry<K, V>> getAll() {
        return new ArrayList<Map.Entry<K, V>>(this.m_Map.entrySet());
    }

    public Set<K> keySet() {
        return this.m_Map.keySet();
    }

    @Override
    public LRUCache<K, V> getClone() {
        LRUCache<K, V> result = new LRUCache<K, V>(this.m_CacheSize);
        result.m_Map = (LinkedHashMap)this.m_Map.clone();
        result.m_Enabled = this.m_Enabled;
        return result;
    }

    public static void main(String[] args) {
        LRUCache<String, String> c = new LRUCache<String, String>(3);
        c.put("1", "one");
        c.put("2", "two");
        c.put("3", "three");
        c.put("4", "four");
        if (c.get("2") == null) {
            throw new Error();
        }
        c.put("5", "five");
        c.put("4", "second four");
        if (c.sizeUsed() != 3) {
            throw new Error();
        }
        if (!((String)c.get("4")).equals("second four")) {
            throw new Error();
        }
        if (!((String)c.get("5")).equals("five")) {
            throw new Error();
        }
        if (!((String)c.get("2")).equals("two")) {
            throw new Error();
        }
        for (Map.Entry e : c.getAll()) {
            System.out.println((String)e.getKey() + " : " + (String)e.getValue());
        }
    }

    protected class LRUCacheLinkedHashMap
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 6485446895298838183L;

        public LRUCacheLinkedHashMap(int capacity, float loadFactor) {
            super(capacity, loadFactor, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > LRUCache.this.m_CacheSize;
        }
    }
}

