/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.base.BaseObject;
import adams.core.base.BaseString;
import adams.data.conversion.AbstractConversion;
import adams.gui.goe.CustomStringRepresentationHandler;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;

public class StringToCustomStringRepresentation
extends AbstractConversion {
    private static final long serialVersionUID = -1819666048086043899L;
    protected String m_Classname;

    @Override
    public String globalInfo() {
        return "Turns a String into an object of a class with an associated object editor that has implements " + CustomStringRepresentationHandler.class.getName() + ". For instance, all " + BaseObject.class.getName() + " dervied classes.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("classname", "classname", BaseString.class.getName());
    }

    public void setClassname(String value) {
        try {
            Class.forName(value);
        }
        catch (Exception e) {
            return;
        }
        this.m_Classname = value;
        this.reset();
    }

    public String getClassname() {
        return this.m_Classname;
    }

    public String classnameTipText() {
        return "The class to convert the strings to.";
    }

    @Override
    public Class accepts() {
        return String.class;
    }

    @Override
    public Class generates() {
        return Object.class;
    }

    @Override
    protected Object doConvert() throws Exception {
        Class<?> cls = Class.forName(this.m_Classname);
        PropertyEditor editor = PropertyEditorManager.findEditor(cls);
        if (!(editor instanceof CustomStringRepresentationHandler)) {
            throw new IllegalStateException("Failed to obtain a " + CustomStringRepresentationHandler.class.getName() + " editor!");
        }
        editor.setValue(cls.newInstance());
        Object result = ((CustomStringRepresentationHandler)((Object)editor)).fromCustomStringRepresentation((String)this.m_Input);
        return result;
    }
}

