/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow;

import adams.core.ClassLister;
import adams.core.Pausable;
import adams.core.Properties;
import adams.core.StatusMessageHandler;
import adams.core.io.FilenameProposer;
import adams.core.io.PlaceholderFile;
import adams.data.statistics.InformativeStatistic;
import adams.db.LogEntryHandler;
import adams.env.Environment;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorStatistic;
import adams.flow.core.InstantiatableActor;
import adams.flow.processor.AbstractActorProcessor;
import adams.flow.processor.GraphicalOutputProducingProcessor;
import adams.flow.processor.ModifyingProcessor;
import adams.flow.processor.RemoveDisabledActors;
import adams.gui.action.AbstractBaseAction;
import adams.gui.action.ToggleAction;
import adams.gui.application.ChildFrame;
import adams.gui.application.ChildWindow;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BaseDialog;
import adams.gui.core.BaseStatusBar;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.RecentFilesHandler;
import adams.gui.core.ToolBarPanel;
import adams.gui.dialog.PropertiesPreferencesDialog;
import adams.gui.event.RecentFileEvent;
import adams.gui.event.RecentFileListener;
import adams.gui.event.TabVisibilityChangeEvent;
import adams.gui.event.TabVisibilityChangeListener;
import adams.gui.event.UndoEvent;
import adams.gui.flow.ExportDialog;
import adams.gui.flow.FlowPanel;
import adams.gui.flow.FlowTabbedPane;
import adams.gui.flow.ImportDialog;
import adams.gui.flow.tab.FlowTabManager;
import adams.gui.flow.tree.Tree;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.tools.VariableManagementPanel;
import adams.gui.visualization.statistics.InformativeStatisticFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FlowEditorPanel
extends ToolBarPanel
implements MenuBarProvider,
StatusMessageHandler,
SendToActionSupporter {
    private static final long serialVersionUID = -3579084888256133873L;
    public static final String FILENAME = "FlowEditor.props";
    public static final String FILENAME_SHORTCUTS = "FlowEditorShortcuts.props";
    public static final String SESSION_FILE = "FlowSession.props";
    public static final String DEFAULT_TITLE = "Flow editor";
    protected static Properties m_Properties;
    protected static Properties m_PropertiesShortcuts;
    protected FlowEditorPanel m_Self;
    protected JMenuBar m_MenuBar;
    protected JMenu m_MenuFileNew;
    protected AbstractBaseAction m_ActionFileLoad;
    protected JMenu m_MenuFileLoadRecent;
    protected AbstractBaseAction m_ActionFileNew;
    protected AbstractBaseAction m_ActionFileSave;
    protected AbstractBaseAction m_ActionFileSaveAs;
    protected AbstractBaseAction m_ActionFileRevert;
    protected AbstractBaseAction m_ActionFileExport;
    protected AbstractBaseAction m_ActionFileImport;
    protected AbstractBaseAction m_ActionFilePreferences;
    protected AbstractBaseAction m_ActionFileCloseTab;
    protected AbstractBaseAction m_ActionFileClose;
    protected AbstractBaseAction m_ActionEditEnableUndo;
    protected AbstractBaseAction m_ActionEditUndo;
    protected AbstractBaseAction m_ActionEditRedo;
    protected AbstractBaseAction m_ActionEditFind;
    protected AbstractBaseAction m_ActionEditFindNext;
    protected AbstractBaseAction m_ActionEditLocateActor;
    protected AbstractBaseAction m_ActionEditCleanUpFlow;
    protected AbstractBaseAction m_ActionEditInteractiveActors;
    protected AbstractBaseAction m_ActionEditProcessActors;
    protected AbstractBaseAction m_ActionDebugEnableAllBreakpoints;
    protected AbstractBaseAction m_ActionDebugDisableAllBreakpoints;
    protected AbstractBaseAction m_ActionDebugVariables;
    protected AbstractBaseAction m_ActionExecutionHeadless;
    protected AbstractBaseAction m_ActionExecutionValidateSetup;
    protected AbstractBaseAction m_ActionExecutionRun;
    protected AbstractBaseAction m_ActionExecutionPauseAndResume;
    protected AbstractBaseAction m_ActionExecutionStop;
    protected AbstractBaseAction m_ActionExecutionDisplayErrors;
    protected AbstractBaseAction m_ActionExecutionClearGraphicalOutput;
    protected AbstractBaseAction m_ActionViewShowToolbar;
    protected AbstractBaseAction m_ActionViewShowQuickInfo;
    protected AbstractBaseAction m_ActionViewShowAnnotations;
    protected AbstractBaseAction m_ActionViewShowInputOutput;
    protected AbstractBaseAction m_ActionViewHighlightVariables;
    protected AbstractBaseAction m_ActionViewRemoveVariableHighlights;
    protected AbstractBaseAction m_ActionViewShowSource;
    protected AbstractBaseAction m_ActionViewStatistics;
    protected AbstractBaseAction m_ActionNewWindow;
    protected AbstractBaseAction m_ActionDuplicateTabInNewWindow;
    protected AbstractBaseAction m_ActionDuplicateTab;
    protected BaseFileChooser m_FileChooser;
    protected BaseStatusBar m_StatusBar;
    protected RecentFilesHandler m_RecentFilesHandler;
    protected FilenameProposer m_FilenameProposer;
    protected JSplitPane m_SplitPane;
    protected FlowTabbedPane m_FlowPanels;
    protected FlowTabManager m_Tabs;
    protected String m_LastVariableSearch;
    protected ImportDialog m_ImportDialog;
    protected ExportDialog m_ExportDialog;
    protected GenericObjectEditorDialog m_DialogProcessActors;
    protected ToolBarPanel.ToolBarLocation m_ToolBarLocation;
    protected VariableManagementPanel m_PanelVariables;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Self = this;
        this.m_RecentFilesHandler = null;
        this.m_LastVariableSearch = "";
        this.m_FileChooser = new BaseFileChooser();
        this.m_FileChooser.addChoosableFileFilter(new ExtensionFileFilter("Flow setups", "flow"));
        this.m_FileChooser.setCurrentDirectory(new PlaceholderFile(FlowEditorPanel.getProperties().getString("InitialDir", "%h")));
        this.m_FileChooser.setDefaultExtension("flow");
        this.m_FileChooser.setAutoAppendExtension(true);
        this.m_FileChooser.setMultiSelectionEnabled(true);
        this.m_FilenameProposer = new FilenameProposer("new", "flow", FlowEditorPanel.getProperties().getString("InitialDir", "%h"));
        this.m_ExportDialog = null;
        this.m_DialogProcessActors = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        Properties props = FlowEditorPanel.getProperties();
        this.getContentPanel().setLayout(new BorderLayout());
        this.m_ToolBarLocation = ToolBarPanel.ToolBarLocation.valueOf(props.getProperty("ToolBar.Location", "NORTH"));
        if (this.m_ToolBarLocation == ToolBarPanel.ToolBarLocation.HIDDEN) {
            this.m_ToolBarLocation = ToolBarPanel.ToolBarLocation.NORTH;
        }
        this.setToolBarLocation(ToolBarPanel.ToolBarLocation.valueOf(props.getProperty("ToolBar.Location", "NORTH")));
        this.m_SplitPane = new JSplitPane(1, true);
        this.m_SplitPane.setDividerLocation(props.getInteger("DividerLocation", 500));
        this.m_SplitPane.setOneTouchExpandable(true);
        this.m_SplitPane.setResizeWeight(0.5);
        this.getContentPanel().add((Component)this.m_SplitPane, "Center");
        this.m_FlowPanels = new FlowTabbedPane(this);
        this.m_SplitPane.setLeftComponent(this.m_FlowPanels);
        this.m_Tabs = new FlowTabManager();
        this.m_Tabs.addTabVisibilityChangeListener(new TabVisibilityChangeListener(){

            @Override
            public void tabVisibilityChanged(TabVisibilityChangeEvent e) {
                if (FlowEditorPanel.this.m_Tabs.getTabCount() == 0) {
                    FlowEditorPanel.this.m_SplitPane.setRightComponent(null);
                } else {
                    FlowEditorPanel.this.m_SplitPane.setRightComponent(FlowEditorPanel.this.m_Tabs);
                }
            }
        });
        if (this.m_Tabs.getTabCount() > 0) {
            this.m_SplitPane.setRightComponent(this.m_Tabs);
        }
        this.m_StatusBar = new BaseStatusBar();
        this.m_StatusBar.setDialogSize(new Dimension(props.getInteger("StatusBar.Width", 600), props.getInteger("StatusBar.Height", 400)));
        this.m_StatusBar.setMouseListenerActive(true);
        this.m_StatusBar.setStatusProcessor(new BaseStatusBar.StatusProcessor(){

            @Override
            public String process(String msg) {
                return msg.replace(": ", ":\n");
            }
        });
        this.getContentPanel().add((Component)this.m_StatusBar, "South");
    }

    @Override
    protected void initActions() {
        Properties props = FlowEditorPanel.getProperties();
        AbstractBaseAction action = new AbstractBaseAction("Flow", "new.gif"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.newTab();
            }
        };
        action.setMnemonic(78);
        action.setAccelerator(this.getEditorShortcut("File.New"));
        this.m_ActionFileNew = action;
        action = new AbstractBaseAction("Open...", "open.gif"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.open();
            }
        };
        action.setMnemonic(79);
        action.setAccelerator(this.getEditorShortcut("File.Open"));
        this.m_ActionFileLoad = action;
        action = new AbstractBaseAction("Save", "save.gif"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.save();
            }
        };
        action.setMnemonic(83);
        action.setAccelerator(this.getEditorShortcut("File.Save"));
        this.m_ActionFileSave = action;
        action = new AbstractBaseAction("Save as...", GUIHelper.getEmptyIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.saveAs();
            }
        };
        action.setMnemonic(65);
        action.setAccelerator(this.getEditorShortcut("File.SaveAs"));
        this.m_ActionFileSaveAs = action;
        action = new AbstractBaseAction("Revert", "refresh.gif"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.revert();
            }
        };
        action.setMnemonic(82);
        action.setAccelerator(this.getEditorShortcut("File.Revert"));
        this.m_ActionFileRevert = action;
        action = new AbstractBaseAction("Close tab"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.m_FlowPanels.removeSelectedTab();
            }
        };
        action.setMnemonic(84);
        action.setAccelerator(this.getEditorShortcut("File.CloseTab"));
        this.m_ActionFileCloseTab = action;
        action = new AbstractBaseAction("Import...", GUIHelper.getEmptyIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.importFlow();
            }
        };
        action.setMnemonic(73);
        action.setAccelerator(this.getEditorShortcut("File.Import"));
        this.m_ActionFileImport = action;
        action = new AbstractBaseAction("Export...", GUIHelper.getEmptyIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.exportFlow();
            }
        };
        action.setMnemonic(69);
        action.setAccelerator(this.getEditorShortcut("File.Export"));
        this.m_ActionFileExport = action;
        action = new AbstractBaseAction("Preferences...", GUIHelper.getEmptyIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.preferences();
            }
        };
        action.setMnemonic(80);
        action.setAccelerator(this.getEditorShortcut("File.Preferences"));
        this.m_ActionFilePreferences = action;
        action = new AbstractBaseAction("Close", "exit.png"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.close();
            }
        };
        action.setMnemonic(67);
        action.setAccelerator(this.getEditorShortcut("File.Exit"));
        this.m_ActionFileClose = action;
        action = new AbstractBaseAction("Undo enabled", GUIHelper.getEmptyIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FlowEditorPanel.this.hasCurrentPanel()) {
                    FlowEditorPanel.this.getCurrentPanel().getUndo().setEnabled(!FlowEditorPanel.this.getCurrentPanel().getUndo().isEnabled());
                }
            }
        };
        action.setMnemonic(78);
        action.setAccelerator(this.getEditorShortcut("Edit.ToggleUndo"));
        action.setEnabled(false);
        action.setSelected(true);
        this.m_ActionEditEnableUndo = action;
        action = new AbstractBaseAction("Undo", "undo.gif"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.undo();
            }
        };
        action.setMnemonic(85);
        action.setAccelerator(this.getEditorShortcut("Edit.Undo"));
        action.setEnabled(false);
        this.m_ActionEditUndo = action;
        action = new AbstractBaseAction("Redo", "redo.gif"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.redo();
            }
        };
        action.setMnemonic(82);
        action.setAccelerator(this.getEditorShortcut("Edit.Redo"));
        action.setEnabled(false);
        this.m_ActionEditRedo = action;
        action = new AbstractBaseAction("Find", "find.gif"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.find();
            }
        };
        action.setMnemonic(70);
        action.setAccelerator(this.getEditorShortcut("Edit.Find"));
        this.m_ActionEditFind = action;
        action = new AbstractBaseAction("Find next", GUIHelper.getEmptyIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.findNext();
            }
        };
        action.setMnemonic(78);
        action.setAccelerator(this.getEditorShortcut("Edit.FindNext"));
        this.m_ActionEditFindNext = action;
        action = new AbstractBaseAction("Locate actor", GUIHelper.getEmptyIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.locateActor();
            }
        };
        action.setMnemonic(76);
        action.setAccelerator(this.getEditorShortcut("Edit.LocateActor"));
        this.m_ActionEditLocateActor = action;
        action = new AbstractBaseAction("Clean up flow", "delete.gif"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.cleanUpFlow();
            }
        };
        action.setMnemonic(67);
        this.m_ActionEditCleanUpFlow = action;
        action = new AbstractBaseAction("Interactive actors", GUIHelper.getEmptyIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.manageInteractiveActors(!FlowEditorPanel.this.m_ActionEditInteractiveActors.isSelected());
            }
        };
        action.setMnemonic(73);
        action.setSelected(true);
        this.m_ActionEditInteractiveActors = action;
        action = new AbstractBaseAction("Process actors...", GUIHelper.getEmptyIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.processActors();
            }
        };
        action.setMnemonic(68);
        action.setAccelerator(this.getEditorShortcut("Edit.ProcessActors"));
        this.m_ActionEditProcessActors = action;
        action = new AbstractBaseAction("Enable all breakpoints", "debug.png"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.enableBreakpoints(true);
            }
        };
        action.setMnemonic(69);
        action.setAccelerator(this.getEditorShortcut("Debug.EnableAllBreakpoints"));
        this.m_ActionDebugEnableAllBreakpoints = action;
        action = new AbstractBaseAction("Disable all breakpoints", "debug_off.png"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.enableBreakpoints(false);
            }
        };
        action.setMnemonic(68);
        action.setAccelerator(this.getEditorShortcut("Debug.DisableAllBreakpoints"));
        this.m_ActionDebugDisableAllBreakpoints = action;
        action = new AbstractBaseAction("Variables", "variable.gif"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.showVariables();
            }
        };
        action.setMnemonic(86);
        action.setAccelerator(this.getEditorShortcut("Debug.Variables"));
        this.m_ActionDebugVariables = action;
        action = new AbstractBaseAction("Validate setup", "validate.png"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.validateSetup();
            }
        };
        action.setMnemonic(86);
        action.setAccelerator(this.getEditorShortcut("Execution.ValidateSetup"));
        this.m_ActionExecutionValidateSetup = action;
        action = new AbstractBaseAction("Run", "run.gif"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.run();
            }
        };
        action.setMnemonic(82);
        action.setAccelerator(this.getEditorShortcut("Execution.Run"));
        this.m_ActionExecutionRun = action;
        action = new AbstractBaseAction("Pause", "pause.gif"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.pauseAndResume();
            }
        };
        action.setMnemonic(85);
        action.setAccelerator(this.getEditorShortcut("Execution.PauseResume"));
        this.m_ActionExecutionPauseAndResume = action;
        action = new AbstractBaseAction("Stop", "stop_blue.gif"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.stop();
            }
        };
        action.setMnemonic(83);
        action.setAccelerator(this.getEditorShortcut("Execution.Stop"));
        this.m_ActionExecutionStop = action;
        action = new AbstractBaseAction("Display errors...", "log.gif"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.displayErrors();
            }
        };
        action.setMnemonic(68);
        this.m_ActionExecutionDisplayErrors = action;
        action = new AbstractBaseAction("Clear graphical output", "close_window.png"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.cleanUp();
                FlowEditorPanel.this.update();
            }
        };
        action.setMnemonic(67);
        action.setAccelerator(this.getEditorShortcut("Execution.ClearGraphicalOutput"));
        this.m_ActionExecutionClearGraphicalOutput = action;
        action = new ToggleAction("Headless", GUIHelper.getEmptyIcon());
        action.setMnemonic(72);
        action.setAccelerator(this.getEditorShortcut("Execution.ToggleHeadless"));
        this.m_ActionExecutionHeadless = action;
        action = new AbstractBaseAction("Show toolbar", GUIHelper.getEmptyIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FlowEditorPanel.this.getToolBarLocation() == ToolBarPanel.ToolBarLocation.HIDDEN) {
                    FlowEditorPanel.this.setToolBarLocation(FlowEditorPanel.this.m_ToolBarLocation);
                } else {
                    FlowEditorPanel.this.setToolBarLocation(ToolBarPanel.ToolBarLocation.HIDDEN);
                }
            }
        };
        action.setMnemonic(84);
        action.setAccelerator(this.getEditorShortcut("View.ShowToolbar"));
        action.setSelected(this.getToolBarLocation() != ToolBarPanel.ToolBarLocation.HIDDEN);
        this.m_ActionViewShowToolbar = action;
        action = new AbstractBaseAction("Show quick info", GUIHelper.getEmptyIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FlowEditorPanel.this.hasCurrentPanel()) {
                    FlowEditorPanel.this.getCurrentPanel().getTree().setShowQuickInfo(FlowEditorPanel.this.m_ActionViewShowQuickInfo.isSelected());
                }
            }
        };
        action.setMnemonic(81);
        action.setAccelerator(this.getEditorShortcut("View.ShowQuickInfo"));
        action.setSelected(props.getBoolean("ShowQuickInfo", true));
        this.m_ActionViewShowQuickInfo = action;
        action = new AbstractBaseAction("Show annotations", GUIHelper.getEmptyIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FlowEditorPanel.this.hasCurrentPanel()) {
                    FlowEditorPanel.this.getCurrentPanel().getTree().setShowAnnotations(FlowEditorPanel.this.m_ActionViewShowAnnotations.isSelected());
                }
            }
        };
        action.setMnemonic(65);
        action.setAccelerator(this.getEditorShortcut("View.ShowAnnotations"));
        action.setSelected(props.getBoolean("ShowAnnotations", false));
        this.m_ActionViewShowAnnotations = action;
        action = new AbstractBaseAction("Show input/output", GUIHelper.getEmptyIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FlowEditorPanel.this.hasCurrentPanel()) {
                    FlowEditorPanel.this.getCurrentPanel().getTree().setShowInputOutput(FlowEditorPanel.this.m_ActionViewShowInputOutput.isSelected());
                }
            }
        };
        action.setMnemonic(80);
        action.setAccelerator(this.getEditorShortcut("View.ShowInputOutput"));
        action.setSelected(props.getBoolean("ShowInputOutput", false));
        this.m_ActionViewShowInputOutput = action;
        action = new AbstractBaseAction("Highlight variables...", GUIHelper.getEmptyIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.highlightVariables(true);
            }
        };
        action.setMnemonic(86);
        action.setAccelerator(this.getEditorShortcut("View.HighlightVariables"));
        this.m_ActionViewHighlightVariables = action;
        action = new AbstractBaseAction("Remove variable highlights", GUIHelper.getEmptyIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.highlightVariables(false);
            }
        };
        action.setMnemonic(82);
        action.setAccelerator(this.getEditorShortcut("View.RemoveVariableHighlights"));
        this.m_ActionViewRemoveVariableHighlights = action;
        action = new AbstractBaseAction("Show source...", "source.png"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.showSource();
            }
        };
        action.setMnemonic(83);
        action.setAccelerator(this.getEditorShortcut("View.ShowSource"));
        this.m_ActionViewShowSource = action;
        action = new AbstractBaseAction("Statistics...", "statistics.png"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.statistics();
            }
        };
        action.setMnemonic(84);
        action.setAccelerator(this.getEditorShortcut("View.Statistics"));
        this.m_ActionViewStatistics = action;
        action = new AbstractBaseAction("New window"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.newWindow();
            }
        };
        action.setMnemonic(87);
        action.setAccelerator(this.getEditorShortcut("Window.NewWindow"));
        this.m_ActionNewWindow = action;
        action = new AbstractBaseAction("Duplicate in new window"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.duplicateTabInNewWindow();
            }
        };
        action.setMnemonic(68);
        action.setAccelerator(this.getEditorShortcut("Window.DuplicateInNewWindow"));
        this.m_ActionDuplicateTabInNewWindow = action;
        action = new AbstractBaseAction("Duplicate in new tab", "copy.gif"){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEditorPanel.this.duplicateTab();
            }
        };
        action.setMnemonic(68);
        action.setAccelerator(this.getEditorShortcut("Window.DuplicateInNewWindow"));
        this.m_ActionDuplicateTab = action;
    }

    @Override
    protected void initToolBar() {
        this.addToToolBar(this.m_ActionFileNew);
        this.addToToolBar(this.m_ActionFileLoad);
        this.addToToolBar(this.m_ActionFileSave);
        this.addSeparator();
        this.addToToolBar(this.m_ActionEditUndo);
        this.addToToolBar(this.m_ActionEditRedo);
        this.addSeparator();
        this.addToToolBar(this.m_ActionEditFind);
        this.addSeparator();
        this.addToToolBar(this.m_ActionExecutionValidateSetup);
        this.addToToolBar(this.m_ActionExecutionRun);
        this.addToToolBar(this.m_ActionExecutionPauseAndResume);
        this.addToToolBar(this.m_ActionExecutionStop);
    }

    @Override
    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            String prefix;
            int i;
            if (this.getParentFrame() != null) {
                JFrame frame = (JFrame)this.getParentFrame();
                frame.setDefaultCloseOperation(0);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        FlowEditorPanel.this.close();
                    }
                });
            } else if (this.getParentDialog() != null) {
                JDialog dialog = (JDialog)this.getParentDialog();
                dialog.setDefaultCloseOperation(0);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        FlowEditorPanel.this.close();
                    }
                });
            }
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    FlowEditorPanel.this.updateActions();
                }
            });
            JMenu submenu = new JMenu("New");
            menu.add(submenu);
            submenu.setMnemonic('N');
            submenu.setIcon(GUIHelper.getIcon("new.gif"));
            this.m_MenuFileNew = submenu;
            String[] actors = ClassLister.getSingleton().getClassnames(InstantiatableActor.class);
            Vector<String> prefixes = new Vector<String>();
            for (i = 0; i < actors.length; ++i) {
                prefix = actors[i].substring(0, actors[i].lastIndexOf(46));
                if (prefixes.contains(prefix)) continue;
                prefixes.add(prefix);
            }
            String prefixPrev = "";
            for (i = 0; i < actors.length; ++i) {
                JMenuItem menuitem;
                final AbstractActor actor = AbstractActor.forName(actors[i], new String[0]);
                prefix = actors[i].substring(0, actors[i].lastIndexOf(46));
                if (!prefix.equals(prefixPrev)) {
                    menuitem = new JMenuItem(prefix);
                    menuitem.setEnabled(false);
                    if (prefixPrev.length() > 0) {
                        submenu.addSeparator();
                    }
                    submenu.add(menuitem);
                    prefixPrev = prefix;
                }
                if (actor instanceof Flow) {
                    menuitem = new JMenuItem(this.m_ActionFileNew);
                    submenu.add(menuitem);
                    continue;
                }
                menuitem = new JMenuItem(actors[i].replaceAll(".*\\.", ""));
                submenu.add(menuitem);
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FlowEditorPanel.this.newFlow(actor);
                    }
                });
            }
            menu.add(new JMenuItem(this.m_ActionFileLoad));
            submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandler(SESSION_FILE, FlowEditorPanel.getProperties().getInteger("MaxRecentFlows", 5), submenu);
            this.m_RecentFilesHandler.addRecentFileListener(new RecentFileListener(){

                @Override
                public void recentFileAdded(RecentFileEvent e) {
                }

                @Override
                public void recentFileSelected(RecentFileEvent e) {
                    FlowPanel panel = FlowEditorPanel.this.m_FlowPanels.newPanel();
                    panel.load(e.getFile());
                }
            });
            this.m_MenuFileLoadRecent = submenu;
            menu.add(new JMenuItem(this.m_ActionFileSave));
            menu.add(new JMenuItem(this.m_ActionFileSaveAs));
            menu.add(new JMenuItem(this.m_ActionFileRevert));
            menu.add(new JMenuItem(this.m_ActionFileCloseTab));
            menu.addSeparator();
            menu.add(new JMenuItem(this.m_ActionFileImport));
            menu.add(new JMenuItem(this.m_ActionFileExport));
            SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, menu);
            menu.addSeparator();
            menu.add(new JMenuItem(this.m_ActionFilePreferences));
            menu.addSeparator();
            menu.add(new JMenuItem(this.m_ActionFileClose));
            menu = new JMenu("Edit");
            result.add(menu);
            menu.setMnemonic('E');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    FlowEditorPanel.this.updateActions();
                }
            });
            menu.add(new JCheckBoxMenuItem(this.m_ActionEditEnableUndo));
            menu.add(new JMenuItem(this.m_ActionEditUndo));
            menu.add(new JMenuItem(this.m_ActionEditRedo));
            menu.addSeparator();
            menu.add(new JMenuItem(this.m_ActionEditFind));
            menu.add(new JMenuItem(this.m_ActionEditFindNext));
            menu.add(new JMenuItem(this.m_ActionEditLocateActor));
            menu.addSeparator();
            menu.add(new JMenuItem(this.m_ActionEditCleanUpFlow));
            menu.add(new JCheckBoxMenuItem(this.m_ActionEditInteractiveActors));
            menu.add(new JMenuItem(this.m_ActionEditProcessActors));
            menu = new JMenu("Debug");
            result.add(menu);
            menu.setMnemonic('D');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    FlowEditorPanel.this.updateActions();
                }
            });
            menu.add(new JMenuItem(this.m_ActionDebugEnableAllBreakpoints));
            menu.add(new JMenuItem(this.m_ActionDebugDisableAllBreakpoints));
            menu.add(new JMenuItem(this.m_ActionDebugVariables));
            menu = new JMenu("Execution");
            result.add(menu);
            menu.setMnemonic('E');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    FlowEditorPanel.this.updateActions();
                }
            });
            menu.add(new JMenuItem(this.m_ActionExecutionValidateSetup));
            menu.add(new JMenuItem(this.m_ActionExecutionRun));
            menu.add(new JMenuItem(this.m_ActionExecutionPauseAndResume));
            menu.add(new JMenuItem(this.m_ActionExecutionStop));
            menu.add(new JMenuItem(this.m_ActionExecutionDisplayErrors));
            menu.add(new JMenuItem(this.m_ActionExecutionClearGraphicalOutput));
            menu.addSeparator();
            menu.add(new JCheckBoxMenuItem(this.m_ActionExecutionHeadless));
            menu = new JMenu("View");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    FlowEditorPanel.this.updateActions();
                }
            });
            menu.add(new JCheckBoxMenuItem(this.m_ActionViewShowToolbar));
            menu.add(new JCheckBoxMenuItem(this.m_ActionViewShowQuickInfo));
            menu.add(new JCheckBoxMenuItem(this.m_ActionViewShowAnnotations));
            menu.add(new JCheckBoxMenuItem(this.m_ActionViewShowInputOutput));
            this.m_Tabs.addTabsSubmenu(menu);
            menu.addSeparator();
            menu.add(new JMenuItem(this.m_ActionViewHighlightVariables));
            menu.add(new JMenuItem(this.m_ActionViewRemoveVariableHighlights));
            menu.addSeparator();
            menu.add(new JMenuItem(this.m_ActionViewShowSource));
            menu.add(new JMenuItem(this.m_ActionViewStatistics));
            if (GUIHelper.getParent(this.m_Self, ChildFrame.class) != null && this.getParentDialog() == null) {
                menu = new JMenu("Window");
                result.add(menu);
                menu.setMnemonic('W');
                menu.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        FlowEditorPanel.this.updateActions();
                    }
                });
                menu.add(new JMenuItem(this.m_ActionNewWindow));
                menu.add(new JMenuItem(this.m_ActionDuplicateTabInNewWindow));
                menu.add(new JMenuItem(this.m_ActionDuplicateTab));
            }
            this.m_MenuBar = result;
            this.updateActions();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    public FlowTabManager getTabs() {
        return this.m_Tabs;
    }

    @Override
    protected void updateActions() {
        boolean hasCurrent = this.hasCurrentPanel();
        if (hasCurrent) {
            this.getCurrentPanel().updateTitle();
        }
        if (this.m_MenuBar == null) {
            return;
        }
        boolean inputEnabled = !this.isRunning() && !this.isStopping() && !this.isSwingWorkerRunning();
        AbstractActor root = this.getCurrentRoot();
        Pausable pausable = root != null && root instanceof Pausable ? (Pausable)((Object)root) : null;
        this.m_MenuFileNew.setEnabled(true);
        this.m_ActionFileNew.setEnabled(true);
        this.m_ActionFileLoad.setEnabled(true);
        this.m_MenuFileLoadRecent.setEnabled(this.m_RecentFilesHandler.size() > 0);
        this.m_ActionFileSave.setEnabled(inputEnabled && hasCurrent);
        this.m_ActionFileSaveAs.setEnabled(inputEnabled && hasCurrent);
        this.m_ActionFileImport.setEnabled(true);
        this.m_ActionFileExport.setEnabled(inputEnabled && hasCurrent);
        this.m_ActionFileRevert.setEnabled(inputEnabled && hasCurrent && this.getCurrentPanel().getCurrentFile() != null && this.getCurrentPanel().getTree().isModified());
        this.m_ActionFileCloseTab.setEnabled(hasCurrent);
        this.m_ActionFileClose.setEnabled(!this.isAnyRunning() && !this.isAnyStopping() && !this.isAnySwingWorkerRunning());
        this.m_ActionEditEnableUndo.setEnabled(inputEnabled && hasCurrent);
        this.m_ActionEditEnableUndo.setSelected(hasCurrent && this.getCurrentPanel().getUndo().isEnabled());
        this.m_ActionEditUndo.setEnabled(inputEnabled && hasCurrent && this.getCurrentPanel().getUndo().canUndo());
        if (hasCurrent && this.getCurrentPanel().getUndo().canUndo()) {
            this.m_ActionEditUndo.setName("Undo - " + this.getCurrentPanel().getUndo().peekUndoComment(true));
            this.m_ActionEditUndo.setToolTipText(this.getCurrentPanel().getUndo().peekUndoComment());
        } else {
            this.m_ActionEditUndo.setName("Undo");
            this.m_ActionEditUndo.setToolTipText(null);
        }
        this.m_ActionEditRedo.setEnabled(inputEnabled && hasCurrent && this.getCurrentPanel().getUndo().canRedo());
        if (hasCurrent && this.getCurrentPanel().getUndo().canRedo()) {
            this.m_ActionEditRedo.setName("Redo - " + this.getCurrentPanel().getUndo().peekRedoComment(true));
            this.m_ActionEditRedo.setToolTipText(this.getCurrentPanel().getUndo().peekRedoComment());
        } else {
            this.m_ActionEditRedo.setName("Redo");
            this.m_ActionEditRedo.setToolTipText(null);
        }
        this.m_ActionEditCleanUpFlow.setEnabled(inputEnabled);
        this.m_ActionEditInteractiveActors.setEnabled(inputEnabled);
        this.m_ActionEditProcessActors.setEnabled(inputEnabled);
        this.m_ActionEditFind.setEnabled(true);
        this.m_ActionEditFindNext.setEnabled(hasCurrent && this.getCurrentPanel().getTree().getLastSearchNode() != null);
        this.m_ActionEditLocateActor.setEnabled(true);
        this.m_ActionViewHighlightVariables.setEnabled(true);
        this.m_ActionViewRemoveVariableHighlights.setEnabled(true);
        this.m_ActionDebugEnableAllBreakpoints.setEnabled(inputEnabled);
        this.m_ActionDebugDisableAllBreakpoints.setEnabled(inputEnabled);
        this.m_ActionDebugVariables.setEnabled(this.isRunning());
        this.m_ActionExecutionValidateSetup.setEnabled(inputEnabled && hasCurrent);
        this.m_ActionExecutionRun.setEnabled(inputEnabled && hasCurrent && this.getCurrentPanel().getTree().isFlow());
        if (pausable != null && pausable.isPaused()) {
            this.m_ActionExecutionPauseAndResume.setIcon(GUIHelper.getIcon("resume.gif"));
            this.m_ActionExecutionPauseAndResume.setName("Resume");
        } else {
            this.m_ActionExecutionPauseAndResume.setIcon(GUIHelper.getIcon("pause.gif"));
            this.m_ActionExecutionPauseAndResume.setName("Pause");
        }
        this.m_ActionExecutionPauseAndResume.setEnabled(this.isRunning());
        this.m_ActionExecutionStop.setEnabled(this.isRunning());
        this.m_ActionExecutionHeadless.setEnabled(inputEnabled);
        this.m_ActionExecutionDisplayErrors.setEnabled(inputEnabled && this.getLastFlow() != null && this.getLastFlow() instanceof LogEntryHandler && ((LogEntryHandler)((Object)this.getLastFlow())).countLogEntries() > 0);
        this.m_ActionExecutionClearGraphicalOutput.setEnabled(inputEnabled && this.getLastFlow() != null);
        this.m_ActionViewShowQuickInfo.setEnabled(hasCurrent);
        this.m_ActionViewShowAnnotations.setEnabled(hasCurrent);
        this.m_ActionViewShowInputOutput.setEnabled(hasCurrent);
        this.m_ActionViewStatistics.setEnabled(hasCurrent);
        this.m_ActionViewShowSource.setEnabled(hasCurrent);
        this.m_ActionViewHighlightVariables.setEnabled(hasCurrent);
        this.m_ActionViewRemoveVariableHighlights.setEnabled(hasCurrent);
        this.m_ActionNewWindow.setEnabled(true);
        this.m_ActionDuplicateTabInNewWindow.setEnabled(hasCurrent);
        this.m_ActionDuplicateTab.setEnabled(hasCurrent);
    }

    protected void updateWidgets() {
        boolean inputEnabled;
        boolean bl = inputEnabled = !this.isRunning() && !this.isStopping();
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().getTree().setEditable(inputEnabled);
        }
    }

    public void update() {
        this.updateActions();
        this.updateWidgets();
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().updateTitle();
        }
    }

    public String getEditorShortcut(String key) {
        return FlowEditorPanel.getPropertiesShortcuts().getProperty("Shortcuts." + key, "");
    }

    public String getTreeShortcut(String key) {
        return FlowEditorPanel.getPropertiesShortcuts().getProperty("Tree.Shortcuts." + key, "");
    }

    protected boolean checkForModified() {
        boolean result;
        if (!this.hasCurrentPanel()) {
            return true;
        }
        boolean bl = result = !this.getCurrentPanel().isModified();
        if (!result) {
            String msg = this.getCurrentPanel().getCurrentFile() == null ? "Flow not saved - save?" : "Flow '" + this.getCurrentPanel().getCurrentFile() + "' not saved - save?";
            int retVal = JOptionPane.showConfirmDialog(this, msg, "Flow not saved", 1);
            switch (retVal) {
                case 0: {
                    if (this.getCurrentPanel().getCurrentFile() != null) {
                        this.save();
                    } else {
                        this.saveAs();
                    }
                    result = !this.getCurrentPanel().isModified();
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                case 2: {
                    result = false;
                }
            }
        }
        return result;
    }

    protected void newFlow(AbstractActor actor) {
        FlowPanel panel = this.m_FlowPanels.newPanel();
        panel.reset(actor);
        this.updateActions();
        this.updateWidgets();
        this.grabFocus();
    }

    protected void setCurrentFile(File value) {
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().setCurrentFile(value);
        }
    }

    public File getCurrentFile() {
        if (this.hasCurrentPanel()) {
            return this.getCurrentPanel().getCurrentFile();
        }
        return null;
    }

    public void loadUnsafe(File file) {
        FlowPanel panel = this.m_FlowPanels.newPanel();
        if (!file.exists()) {
            panel.reset(new Flow());
            panel.setCurrentFile(new File(file.getAbsolutePath()));
            this.updateActions();
        } else {
            panel.load(file);
        }
    }

    public void setCurrentFlow(AbstractActor flow) {
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().setCurrentFlow(flow);
        }
    }

    public boolean hasCurrentPanel() {
        return this.m_FlowPanels.hasCurrentPanel();
    }

    public FlowPanel getCurrentPanel() {
        return this.m_FlowPanels.getCurrentPanel();
    }

    public AbstractActor getCurrentRoot() {
        if (this.hasCurrentPanel()) {
            return this.getCurrentPanel().getCurrentRoot();
        }
        return null;
    }

    public AbstractActor getCurrentFlow() {
        if (this.hasCurrentPanel()) {
            return this.getCurrentPanel().getCurrentFlow();
        }
        return null;
    }

    public AbstractActor getLastFlow() {
        if (this.hasCurrentPanel()) {
            return this.getCurrentPanel().getLastFlow();
        }
        return null;
    }

    public void setModified(boolean value) {
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().getTree().setModified(value);
        }
        this.update();
    }

    public boolean isModified() {
        return this.hasCurrentPanel() && this.getCurrentPanel().getTree().isModified();
    }

    public void newTab() {
        this.m_FlowPanels.newPanel();
    }

    protected void open() {
        int retVal = this.m_FileChooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        for (PlaceholderFile file : this.m_FileChooser.getSelectedPlaceholderFiles()) {
            FlowPanel panel = this.m_FlowPanels.newPanel();
            panel.load(file);
        }
    }

    protected void revert() {
        if (!this.hasCurrentPanel()) {
            return;
        }
        if (!this.checkForModified()) {
            return;
        }
        this.getCurrentPanel().revert();
    }

    protected void save() {
        FlowPanel panel = this.getCurrentPanel();
        if (panel == null) {
            return;
        }
        if (panel.getCurrentFile() == null) {
            this.saveAs();
            return;
        }
        panel.save(panel.getCurrentFile());
    }

    protected void saveAs() {
        FlowPanel panel = this.getCurrentPanel();
        if (panel == null) {
            return;
        }
        File file = panel.getCurrentFile();
        if (file == null) {
            file = new PlaceholderFile(this.getCurrentDirectory() + File.separator + panel.getTitle() + "." + "flow");
        }
        if (file.exists()) {
            file = this.m_FilenameProposer.propose(file);
        }
        this.m_FileChooser.setSelectedFile(file);
        int retVal = this.m_FileChooser.showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        file = this.m_FileChooser.getSelectedPlaceholderFile();
        panel.addUndoPoint("Saving undo data...", "Saving as '" + file.getName() + "'");
        this.showStatus("Saving as '" + file + "'...");
        panel.save(this.m_FileChooser.getSelectedPlaceholderFile());
    }

    protected void importFlow() {
        if (this.m_ImportDialog == null) {
            this.m_ImportDialog = this.getParentDialog() != null ? new ImportDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new ImportDialog(this.getParentFrame(), true);
        }
        this.m_ImportDialog.setLocationRelativeTo(this);
        this.m_ImportDialog.setVisible(true);
        if (this.m_ImportDialog.getOption() != 0) {
            return;
        }
        FlowPanel panel = this.m_FlowPanels.newPanel();
        panel.importFlow(this.m_ImportDialog.getConsumer(), this.m_ImportDialog.getFile());
    }

    protected void exportFlow() {
        FlowPanel panel = this.getCurrentPanel();
        if (panel == null) {
            return;
        }
        if (this.m_ExportDialog == null) {
            this.m_ExportDialog = this.getParentDialog() != null ? new ExportDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new ExportDialog(this.getParentFrame(), true);
        }
        this.m_ExportDialog.setLocationRelativeTo(this);
        this.m_ExportDialog.setVisible(true);
        if (this.m_ExportDialog.getOption() != 0) {
            return;
        }
        panel.exportFlow(this.m_ExportDialog.getProducer(), this.m_ExportDialog.getFile());
    }

    protected void validateSetup() {
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().validateSetup();
        }
    }

    public void run() {
        this.run(true);
    }

    public void run(boolean showNotification) {
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().run(showNotification);
        }
    }

    public boolean isRunning() {
        if (this.getCurrentPanel() == null) {
            return false;
        }
        return this.getCurrentPanel().isRunning();
    }

    public boolean isAnyRunning() {
        boolean result = false;
        for (int i = 0; i < this.m_FlowPanels.getPanelCount(); ++i) {
            if (!this.m_FlowPanels.getPanelAt(i).isRunning()) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isStopping() {
        if (this.getCurrentPanel() == null) {
            return false;
        }
        return this.getCurrentPanel().isStopping();
    }

    public boolean isAnyStopping() {
        boolean result = false;
        for (int i = 0; i < this.m_FlowPanels.getPanelCount(); ++i) {
            if (!this.m_FlowPanels.getPanelAt(i).isStopping()) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isSwingWorkerRunning() {
        if (this.getCurrentPanel() == null) {
            return false;
        }
        return this.getCurrentPanel().isSwingWorkerRunning();
    }

    public boolean isAnySwingWorkerRunning() {
        boolean result = false;
        for (int i = 0; i < this.m_FlowPanels.getPanelCount(); ++i) {
            if (!this.m_FlowPanels.getPanelAt(i).isSwingWorkerRunning()) continue;
            result = true;
            break;
        }
        return result;
    }

    protected void pauseAndResume() {
        if (!this.hasCurrentPanel()) {
            return;
        }
        if (this.getCurrentPanel().pauseAndResume()) {
            this.m_ActionExecutionPauseAndResume.setName("Resume");
        } else {
            this.m_ActionExecutionPauseAndResume.setName("Pause");
        }
        this.updateActions();
    }

    public void stop() {
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().stop();
        }
    }

    public void displayErrors() {
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().displayErrors();
        }
    }

    public void cleanUp() {
        this.m_FlowPanels.cleanUp();
    }

    protected void preferences() {
        PropertiesPreferencesDialog dialog = this.getParentDialog() != null ? new PropertiesPreferencesDialog(this.getParentDialog()) : new PropertiesPreferencesDialog(this.getParentFrame());
        dialog.addPreferenceType("InitialDir", PropertiesPreferencesDialog.PreferenceType.DIRECTORY);
        dialog.addPreferenceType("MaxRecentFlows", PropertiesPreferencesDialog.PreferenceType.INTEGER);
        dialog.addPreferenceType("ShowQuickInfo", PropertiesPreferencesDialog.PreferenceType.BOOLEAN);
        dialog.addPreferenceType("ShowAnnotations", PropertiesPreferencesDialog.PreferenceType.BOOLEAN);
        dialog.addPreferenceType("ShowInputOutput", PropertiesPreferencesDialog.PreferenceType.BOOLEAN);
        dialog.addPreferenceType("DividerLocation", PropertiesPreferencesDialog.PreferenceType.INTEGER);
        dialog.addPreferenceType("Tree.ActorName.Size", PropertiesPreferencesDialog.PreferenceType.INTEGER);
        dialog.addPreferenceType("Tree.ActorName.Color", PropertiesPreferencesDialog.PreferenceType.COLOR);
        dialog.addPreferenceType("Tree.QuickInfo.Size", PropertiesPreferencesDialog.PreferenceType.INTEGER);
        dialog.addPreferenceType("Tree.QuickInfo.Color", PropertiesPreferencesDialog.PreferenceType.COLOR);
        dialog.addPreferenceType("Tree.Annotations.Size", PropertiesPreferencesDialog.PreferenceType.INTEGER);
        dialog.addPreferenceType("Tree.Annotations.Color", PropertiesPreferencesDialog.PreferenceType.COLOR);
        dialog.addPreferenceType("Tree.InputOutput.Size", PropertiesPreferencesDialog.PreferenceType.INTEGER);
        dialog.addPreferenceType("Tree.InputOutput.Color", PropertiesPreferencesDialog.PreferenceType.COLOR);
        dialog.addPreferenceType("Tree.Placeholders.Size", PropertiesPreferencesDialog.PreferenceType.INTEGER);
        dialog.addPreferenceType("Tree.Placeholders.Color", PropertiesPreferencesDialog.PreferenceType.COLOR);
        dialog.addPreferenceType("Tree.VariableHighlight.Background", PropertiesPreferencesDialog.PreferenceType.COLOR);
        dialog.addPreferenceType("Tree.StateUsesNested", PropertiesPreferencesDialog.PreferenceType.BOOLEAN);
        dialog.addPreferenceType("Tree.IconScaleFactor", PropertiesPreferencesDialog.PreferenceType.DOUBLE);
        dialog.addPreferenceType("ClassTree.ShowGlobalInfo", PropertiesPreferencesDialog.PreferenceType.BOOLEAN);
        dialog.addPreferenceType("StatusBar.Width", PropertiesPreferencesDialog.PreferenceType.INTEGER);
        dialog.addPreferenceType("StatusBar.Height", PropertiesPreferencesDialog.PreferenceType.INTEGER);
        dialog.setPreferences(Environment.getInstance().read("flow editor panel"));
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return;
        }
        if (!Environment.getInstance().write("flow editor panel", dialog.getPreferences())) {
            GUIHelper.showErrorMessage(this, "Failed to save preferences!");
        } else {
            m_Properties = null;
            GUIHelper.showInformationMessage(this, "Successfully saved preferences - please re-open the Flow editor!");
        }
    }

    protected void setVisibleAgain() {
        if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(true);
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(true);
        }
    }

    protected void close() {
        if (this.isAnyRunning()) {
            GUIHelper.showErrorMessage(this, "Flows are being executed - closing cancelled!");
            this.setVisibleAgain();
            return;
        }
        if (this.isAnyStopping()) {
            GUIHelper.showErrorMessage(this, "Flows are being stopped - closing cancelled!");
            this.setVisibleAgain();
            return;
        }
        if (!this.checkForModified()) {
            this.setVisibleAgain();
            return;
        }
        this.cleanUp();
        if (this.getParentFrame() != null) {
            ((JFrame)this.getParentFrame()).setDefaultCloseOperation(2);
        }
        this.closeParent();
    }

    protected void statistics() {
        if (!this.hasCurrentPanel()) {
            return;
        }
        ActorStatistic stats = null;
        if (this.getCurrentPanel().getTree().getSelectedNode() != null) {
            stats = new ActorStatistic(this.getCurrentPanel().getTree().getSelectedNode().getFullActor());
        } else if (this.getCurrentRoot() != null) {
            stats = new ActorStatistic(this.getCurrentFlow());
        }
        Vector<InformativeStatistic> statsList = new Vector<InformativeStatistic>();
        statsList.add(stats);
        InformativeStatisticFactory.Dialog dialog = this.getParentDialog() != null ? InformativeStatisticFactory.getDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : InformativeStatisticFactory.getDialog(this.getParentFrame(), true);
        dialog.setStatistics(statsList);
        dialog.setTitle("Actor statistics");
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    public void undo() {
        FlowPanel panel = this.getCurrentPanel();
        if (panel == null) {
            return;
        }
        panel.undo();
    }

    public void redo() {
        FlowPanel panel = this.getCurrentPanel();
        if (panel == null) {
            return;
        }
        panel.redo();
    }

    protected void find() {
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().getTree().find();
        }
    }

    protected void findNext() {
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().getTree().findNext();
        }
    }

    protected void locateActor() {
        String path = JOptionPane.showInputDialog("Please enter the full name of the actor (e.g., 'Flow[0].Sequence[3].Display'):");
        if (path == null) {
            return;
        }
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().getTree().locateAndDisplay(path);
        }
    }

    protected void highlightVariables(boolean highlight) {
        if (!this.hasCurrentPanel()) {
            return;
        }
        if (highlight) {
            String regexp = JOptionPane.showInputDialog(this, "Enter the regular expression for the variable name ('.*' matches all):", this.m_LastVariableSearch);
            if (regexp == null) {
                return;
            }
            this.m_LastVariableSearch = regexp;
            this.getCurrentPanel().getTree().highlightVariables(this.m_LastVariableSearch);
        } else {
            this.getCurrentPanel().getTree().highlightVariables(null);
        }
    }

    protected void cleanUpFlow() {
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().cleanUpFlow();
        }
    }

    protected void manageInteractiveActors(boolean enable) {
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().manageInteractiveActors(enable);
        }
    }

    protected void processActors() {
        GraphicalOutputProducingProcessor graphical;
        ModifyingProcessor modiyfing;
        if (!this.hasCurrentPanel()) {
            return;
        }
        if (this.m_DialogProcessActors == null) {
            this.m_DialogProcessActors = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog()) : new GenericObjectEditorDialog(this.getParentFrame());
            this.m_DialogProcessActors.setTitle("Process actors");
            this.m_DialogProcessActors.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            this.m_DialogProcessActors.getGOEEditor().setCanChangeClassInDialog(true);
            this.m_DialogProcessActors.getGOEEditor().setClassType(AbstractActorProcessor.class);
            this.m_DialogProcessActors.setCurrent(new RemoveDisabledActors());
        }
        this.m_DialogProcessActors.setLocationRelativeTo(this);
        this.m_DialogProcessActors.setVisible(true);
        if (this.m_DialogProcessActors.getResult() != 0) {
            return;
        }
        AbstractActorProcessor processor = (AbstractActorProcessor)this.m_DialogProcessActors.getCurrent();
        processor.process(this.getCurrentFlow());
        if (processor instanceof ModifyingProcessor && (modiyfing = (ModifyingProcessor)((Object)processor)).isModified()) {
            this.getCurrentPanel().addUndoPoint("Saving undo data...", "Processing actors with " + processor.toString());
            this.getCurrentPanel().getTree().buildTree(modiyfing.getModifiedActor());
            this.getCurrentPanel().getTree().setModified(true);
            this.update();
        }
        if (processor instanceof GraphicalOutputProducingProcessor && (graphical = (GraphicalOutputProducingProcessor)((Object)processor)).hasGraphicalOutput()) {
            BaseDialog dialog = this.getParentDialog() != null ? new BaseDialog(this.getParentDialog()) : new BaseDialog(this.getParentFrame());
            dialog.setTitle(processor.getClass().getSimpleName());
            dialog.getContentPane().setLayout(new BorderLayout());
            dialog.getContentPane().add(graphical.getGraphicalOutput(), "Center");
            dialog.pack();
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        this.showMessage("Actors processed!", false);
    }

    protected void enableBreakpoints(boolean enable) {
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().getTree().enableBreakpoints(enable);
        }
    }

    protected void showVariables() {
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().showVariables();
        }
    }

    public FlowEditorPanel newWindow() {
        return this.newWindow(null);
    }

    public FlowEditorPanel newWindow(AbstractActor actor) {
        FlowEditorPanel result = null;
        ChildFrame oldFrame = (ChildFrame)GUIHelper.getParent(this.m_Self, ChildFrame.class);
        if (oldFrame != null) {
            ChildFrame newFrame = oldFrame.getNewWindow();
            newFrame.setVisible(true);
            result = (FlowEditorPanel)newFrame.getContentPane().getComponent(0);
        } else {
            ChildWindow oldWindow = (ChildWindow)GUIHelper.getParent(this.m_Self, ChildWindow.class);
            if (oldWindow != null) {
                ChildWindow newWindow = oldWindow.getNewWindow();
                newWindow.setVisible(true);
                result = (FlowEditorPanel)newWindow.getContentPane().getComponent(0);
            }
        }
        if (result != null) {
            result.setCurrentDirectory(this.getCurrentDirectory());
            if (actor != null) {
                result.setCurrentFlow(actor);
                result.getCurrentPanel().getTree().setModified(true);
            }
            result.update();
        }
        return result;
    }

    protected void showSource() {
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().showSource();
        }
    }

    public Window duplicateTabInNewWindow() {
        Window result = null;
        FlowEditorPanel panel = null;
        ChildFrame oldFrame = (ChildFrame)GUIHelper.getParent(this.m_Self, ChildFrame.class);
        if (oldFrame != null) {
            ChildFrame newFrame = oldFrame.getNewWindow();
            newFrame.setVisible(true);
            panel = (FlowEditorPanel)newFrame.getContentPane().getComponent(0);
            result = newFrame;
        } else {
            ChildWindow oldWindow = (ChildWindow)GUIHelper.getParent(this.m_Self, ChildWindow.class);
            if (oldWindow != null) {
                ChildWindow newWindow = oldWindow.getNewWindow();
                newWindow.setVisible(true);
                panel = (FlowEditorPanel)newWindow.getContentPane().getComponent(0);
                result = newWindow;
            }
        }
        if (panel != null) {
            panel.setCurrentDirectory(this.getCurrentDirectory());
            panel.newTab();
            panel.setCurrentFlow(this.getCurrentPanel().getCurrentFlow());
            panel.setCurrentFile(this.getCurrentPanel().getCurrentFile());
            panel.setModified(this.getCurrentPanel().isModified());
            panel.update();
        }
        return result;
    }

    public FlowPanel duplicateTab() {
        FlowPanel result = null;
        FlowPanel current = this.getCurrentPanel();
        if (current != null) {
            result = this.m_FlowPanels.newPanel();
            result.setCurrentFlow(current.getCurrentFlow());
            result.setCurrentFile(current.getCurrentFile());
            result.setModified(current.isModified());
        }
        return result;
    }

    protected void showMessage() {
        if (this.m_StatusBar.hasStatus()) {
            this.showMessage(this.m_StatusBar.getStatus(), false);
        }
    }

    protected void showMessage(String msg, boolean isError) {
        String status = msg.replaceAll(": ", ":\n");
        if (isError) {
            GUIHelper.showErrorMessage(this, status, "Error");
        } else {
            GUIHelper.showInformationMessage(this, status, "Status");
        }
    }

    @Override
    public void showStatus(String msg) {
        this.m_StatusBar.showStatus(msg);
    }

    public void undoOccurred(UndoEvent e) {
        this.updateActions();
    }

    public void setCurrentDirectory(File value) {
        this.m_FileChooser.setCurrentDirectory(value);
        this.m_FilenameProposer.setDirectory(value.getAbsolutePath());
    }

    public File getCurrentDirectory() {
        return this.m_FileChooser.getCurrentDirectory();
    }

    @Override
    public void grabFocus() {
        if (this.hasCurrentPanel()) {
            this.getCurrentPanel().grabFocus();
        }
    }

    public void refreshTabs() {
        this.m_Tabs.refresh(this.getCurrentTree());
    }

    public Tree getCurrentTree() {
        return this.m_FlowPanels.getCurrentTree();
    }

    public RecentFilesHandler getRecentFilesHandler() {
        return this.m_RecentFilesHandler;
    }

    @Override
    public Class[] getSendToClasses() {
        return new FlowPanel(this.m_FlowPanels).getSendToClasses();
    }

    @Override
    public boolean hasSendToItem(Class[] cls) {
        return this.hasCurrentPanel() && this.getCurrentPanel().hasSendToItem(cls);
    }

    @Override
    public Object getSendToItem(Class[] cls) {
        if (this.hasCurrentPanel()) {
            return this.getCurrentPanel().getSendToItem(cls);
        }
        return null;
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("flow editor panel");
        }
        return m_Properties;
    }

    public static synchronized Properties getPropertiesShortcuts() {
        if (m_PropertiesShortcuts == null) {
            m_PropertiesShortcuts = Environment.getInstance().read("flow editor panel shortcuts");
        }
        return m_PropertiesShortcuts;
    }
}

