/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.inspectionhandler;

import adams.core.ClassLister;
import adams.gui.goe.DefaultGenericObjectEditorHandler;
import adams.gui.visualization.debug.inspectionhandler.DefaultInspectionHandler;
import java.util.Hashtable;

public abstract class AbstractInspectionHandler {
    protected static Hashtable<Class, Class> m_Cache = new Hashtable();
    protected static String[] m_Handlers = null;
    protected static Class[] m_HandlerClasses = null;

    protected static synchronized void initHandlers() {
        if (m_Handlers != null) {
            return;
        }
        m_Handlers = ClassLister.getSingleton().getClassnames(AbstractInspectionHandler.class);
        m_HandlerClasses = new Class[m_Handlers.length];
        for (int i = 0; i < m_Handlers.length; ++i) {
            try {
                AbstractInspectionHandler.m_HandlerClasses[i] = Class.forName(m_Handlers[i]);
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate inspection handler '" + m_Handlers[i] + "': ");
                e.printStackTrace();
            }
        }
    }

    public static synchronized AbstractInspectionHandler getHandler(Object obj) {
        return AbstractInspectionHandler.getHandler(obj.getClass());
    }

    public static synchronized AbstractInspectionHandler getHandler(Class cls) {
        AbstractInspectionHandler result = null;
        AbstractInspectionHandler.initHandlers();
        if (m_Cache.containsKey(cls)) {
            try {
                result = (AbstractInspectionHandler)m_Cache.get(cls).newInstance();
                return result;
            }
            catch (Exception e) {
                result = null;
            }
        }
        for (int i = 0; i < m_HandlerClasses.length; ++i) {
            if (m_HandlerClasses[i] == DefaultGenericObjectEditorHandler.class) continue;
            try {
                AbstractInspectionHandler handler = (AbstractInspectionHandler)m_HandlerClasses[i].newInstance();
                if (!handler.handles(cls)) continue;
                result = handler;
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (result == null) {
            result = new DefaultInspectionHandler();
        }
        m_Cache.put(cls, result.getClass());
        return result;
    }

    public abstract boolean handles(Object var1);

    public abstract Hashtable<String, Object> inspect(Object var1);

    public static String[] getHandlers() {
        return ClassLister.getSingleton().getClassnames(AbstractInspectionHandler.class);
    }
}

