/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.report.reportfactory;

import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.db.ReportProvider;
import adams.gui.action.AbstractBaseAction;
import adams.gui.chooser.AbstractReportFileChooser;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.report.ReportFactory;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public abstract class AbstractTableAction
extends AbstractBaseAction {
    private static final long serialVersionUID = 3352294109225825118L;
    public static final String SEPARATOR = "-";
    public static final String KEY_TABLE = "table";
    public static final String KEY_ROW = "row";
    public static final String KEY_FIELD = "field";
    public static final String KEY_VALUE = "value";

    public AbstractTableAction() {
    }

    public AbstractTableAction(String name) {
        super(name);
    }

    public AbstractTableAction(String name, Icon icon) {
        super(name, icon);
    }

    public AbstractTableAction(String name, String icon) {
        super(name, icon);
    }

    protected void setTable(ReportFactory.Table value) {
        this.putValue(KEY_TABLE, value);
    }

    protected ReportFactory.Table getTable() {
        return (ReportFactory.Table)this.getValue(KEY_TABLE);
    }

    protected void setRow(Integer value) {
        this.putValue(KEY_ROW, value);
    }

    protected Integer getRow() {
        return (Integer)this.getValue(KEY_ROW);
    }

    protected void setField(AbstractField value) {
        this.putValue(KEY_FIELD, value);
    }

    protected AbstractField getField() {
        return (AbstractField)this.getValue(KEY_FIELD);
    }

    protected void setValue(String value) {
        this.putValue(KEY_VALUE, value);
    }

    protected String getValue() {
        return (String)this.getValue(KEY_VALUE);
    }

    protected ReportProvider getReportProvider() {
        if (this.getTable() != null) {
            return this.getTable().getReportProvider();
        }
        return null;
    }

    protected void setReport(Report value) {
        if (this.getTable() != null) {
            this.getTable().setReport(value);
        }
    }

    protected Report getReport() {
        if (this.getTable() != null) {
            return this.getTable().getReport();
        }
        return null;
    }

    protected AbstractReportFileChooser getFileChooser() {
        if (this.getTable() != null) {
            return this.getTable().getFileChooser();
        }
        return null;
    }

    protected Double parseDouble(String s) {
        Double result;
        try {
            result = Double.parseDouble(s);
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
            GUIHelper.showErrorMessage(this.getTable(), "Error parsing value '" + s + "':\n" + e);
        }
        return result;
    }

    protected Boolean parseBoolean(String s) {
        Boolean result;
        try {
            result = Boolean.parseBoolean(s);
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
            GUIHelper.showErrorMessage(this.getTable(), "Error parsing value '" + s + "':\n" + e);
        }
        return result;
    }

    public abstract boolean isApplicable(ReportFactory.Table var1, int var2, AbstractField var3, String var4);

    public static JPopupMenu createPopup(String[] actions2, ReportFactory.Table table, int row) {
        JPopupMenu result = new JPopupMenu();
        AbstractField field = table.getFieldAt(row);
        Object value = table.getValueAt(row, 2);
        String valueStr = value == null ? "" : "" + value;
        boolean wasSeparator = false;
        for (String action : actions2) {
            if (action.equals(SEPARATOR)) {
                if (wasSeparator) continue;
                result.addSeparator();
                wasSeparator = true;
                continue;
            }
            try {
                AbstractTableAction taction = (AbstractTableAction)Class.forName(action).newInstance();
                if (!taction.isApplicable(table, row, field, valueStr)) continue;
                taction.setTable(table);
                taction.setRow(row);
                taction.setField(field);
                taction.setValue(valueStr);
                wasSeparator = false;
                result.add(taction);
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate table action '" + action + "':");
                e.printStackTrace();
            }
        }
        return result;
    }
}

