/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.report.reportfactory;

import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Report;
import adams.gui.visualization.report.ReportFactory;
import adams.gui.visualization.report.reportfactory.AbstractTableAction;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

public class ModifyValue
extends AbstractTableAction {
    private static final long serialVersionUID = -8462082833012930410L;

    public ModifyValue() {
        super("Modify");
    }

    @Override
    protected void setField(AbstractField value) {
        super.setField(value);
        if (this.getField().getDataType() == DataType.BOOLEAN) {
            this.setName("Toggle '" + this.getField().toDisplayString() + "'");
        } else {
            this.setName("Modify '" + this.getField().toDisplayString() + "'");
        }
    }

    @Override
    public boolean isApplicable(ReportFactory.Table table, int row, AbstractField field, String value) {
        boolean result = true;
        switch (field.getDataType()) {
            case BOOLEAN: {
                result = this.parseBoolean(value) != null;
                break;
            }
            case NUMERIC: {
                result = this.parseDouble(value) != null;
            }
        }
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String value = this.getValue();
        Report report = this.getReport();
        switch (this.getField().getDataType()) {
            case BOOLEAN: {
                report.setValue(this.getField(), this.parseBoolean(value) == false);
                this.setReport(report);
                break;
            }
            case NUMERIC: {
                String newValue;
                Double valueDbl = this.parseDouble(value);
                if (valueDbl == null) {
                    valueDbl = 0.0;
                }
                String valueInit = valueDbl.toString();
                do {
                    if ((newValue = JOptionPane.showInputDialog("Enter numeric value for '" + this.getField().toDisplayString() + "'", (Object)valueInit)) != null) continue;
                    return;
                } while ((valueDbl = this.parseDouble(newValue)) == null);
                report.setValue(this.getField(), valueDbl);
                this.setReport(report);
                break;
            }
            case STRING: {
                String newValue = JOptionPane.showInputDialog("Enter value for '" + this.getField().toDisplayString() + "'", (Object)value);
                if (newValue == null) {
                    return;
                }
                report.setValue(this.getField(), newValue);
                this.setReport(report);
                break;
            }
            default: {
                System.err.println(this.getClass().getName() + "/actionPerformed: unhandled data type '" + this.getField().getDataType() + "'!");
            }
        }
    }
}

