/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * ConsoleLog.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.core.io;

/**
 * Simple logger that just outputs the logging information to stdout or stderr.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public class ConsoleLog
  extends Log {

  /** for serialization. */
  private static final long serialVersionUID = -3666917058226291266L;

  /**
   * Logs the message.
   *
   * @param msg		the message to log
   * @param out		whether to log default output (= true) or error output (= false)
   * @param newline	whether to add a newline or not
   */
  protected synchronized void doLog(String msg, boolean out, boolean newline) {
    if (out) {
      if (newline)
	System.out.println(msg);
      else
	System.out.print(msg);
    }
    else {
      if (newline)
	System.err.println(msg);
      else
	System.err.print(msg);
    }
  }
}
