/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * NodePopupMenuCustomizer.java
 * Copyright (C) 2009-2011 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.flow.tree;

import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

/**
 * Interface for classes that want to customize the popup menu that is
 * displayed on nodes.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public interface NodePopupMenuCustomizer {

  /**
   * Customizes the popup menu.
   *
   * @param tree	the tree to work with
   * @param menu	the menu so far
   * @param paths	the paths in the tree that the menu is generated for
   */
  public void customizeNodePopupMenu(Tree tree, JPopupMenu menu, TreePath[] paths);
}
