/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * JMap.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.gui.menu;

import javax.swing.JOptionPane;
import javax.swing.SwingWorker;

import adams.core.management.ProcessUtils;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AbstractMenuItemDefinition;
import adams.gui.application.UserMode;
import adams.gui.dialog.TextDialog;

/**
 * Runs jmap and displays the result.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 * @see adams.core.management.JMap
 */
public class JMap
  extends AbstractMenuItemDefinition {

  /** for serialization. */
  private static final long serialVersionUID = -1502903491659697700L;

  /**
   * Initializes the menu item with no owner.
   */
  public JMap() {
    this(null);
  }

  /**
   * Initializes the menu item.
   *
   * @param owner	the owning application
   */
  public JMap(AbstractApplicationFrame owner) {
    super(owner);
  }

  /**
   * Returns the file name of the icon.
   *
   * @return		the filename or null if no icon available
   */
  public String getIconName() {
    return "duke.png";
  }

  /**
   * Launches the functionality of the menu item.
   */
  public void launch() {
    // query for options
    String options = JOptionPane.showInputDialog(
	null, "Enter the options for " + adams.core.management.JMap.EXECUTABLE + ":",
	adams.core.management.JMap.getDefaultOptions());
    if (options == null)
      return;

    // run jmap and display output
    final long fPid = ProcessUtils.getVirtualMachinePID();
    final String fOptions = options;
    SwingWorker worker = new SwingWorker() {
      protected String m_Output = null;
      protected Object doInBackground() throws Exception {
	m_Output = adams.core.management.JMap.execute(fOptions, fPid);
	return null;
      }
      protected void done() {
	TextDialog dialog = new TextDialog();
	dialog.setTitle(adams.core.management.JMap.EXECUTABLE + " (" + fPid + ")");
	dialog.setContent(m_Output);
	dialog.setLocationRelativeTo(getOwner());
	dialog.setVisible(true);
	super.done();
      }
    };
    worker.execute();
  }

  /**
   * Returns the title of the window (and text of menuitem).
   *
   * @return 		the title
   */
  public String getTitle() {
    return "JMap";
  }

  /**
   * Whether the panel can only be displayed once.
   *
   * @return		true if the panel can only be displayed once
   */
  public boolean isSingleton() {
    return false;
  }

  /**
   * Returns the user mode, which determines visibility as well.
   *
   * @return		the user mode
   */
  public UserMode getUserMode() {
    return UserMode.DEVELOPER;
  }

  /**
   * Returns the category of the menu item in which it should appear, i.e.,
   * the name of the menu.
   *
   * @return		the category/menu name
   */
  public String getCategory() {
    return CATEGORY_HELP;
  }
}