/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * AddDataFile.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.scripting;

import java.util.Vector;

import adams.core.option.OptionUtils;
import adams.data.container.DataContainer;
import adams.data.io.input.AbstractDataContainerReader;
import adams.gui.visualization.container.Container;
import adams.gui.visualization.container.ContainerManager;

/**
 <!-- scriptlet-parameters-start -->
 * Action parameters:<br/>
 * <pre>   add-data-file &lt;datacontainer-reader scheme&gt;</pre>
 * <p/>
 <!-- scriptlet-parameters-end -->
 *
 <!-- scriptlet-description-start -->
 * Description:
 * <pre>   Adds the data container loaded via the given reader to the currently loaded
 *    ones.</pre>
 * <p/>
 <!-- scriptlet-description-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public class AddDataFile
  extends AbstractDataContainerPanelScriptlet {

  /** for serialization. */
  private static final long serialVersionUID = -3048379013750352301L;

  /** the action to execute. */
  public final static String ACTION = "add-data-file";

  /**
   * Returns the action string used in the command processor.
   *
   * @return		the action string
   */
  public String getAction() {
    return ACTION;
  }

  /**
   * Returns a one-line listing of the options of the action.
   *
   * @return		the options or null if none
   */
  protected String getOptionsDescription() {
    return "<datacontainer-reader scheme>";
  }

  /**
   * Returns the full description of the action.
   *
   * @return		the full description
   */
  public String getDescription() {
    return
        "Adds the data container loaded via the given reader to the currently "
      + "loaded ones.";
  }

  /**
   * Processes the options.
   *
   * @param options	additional/optional options for the action
   * @return		null if no error, otherwise error message
   * @throws Exception 	if something goes wrong
   */
  public String process(String options) throws Exception {
    String			result;
    Vector<DataContainer> 	data;
    AbstractDataContainerReader	reader;
    Vector<Container> 		cont;
    int				i;
    ContainerManager		manager;

    result = null;

    // obtain reader
    reader = AbstractDataContainerReader.forCommandLine(options);

    // undo
    addUndoPoint("Saving undo data...", "Loading data with: " + OptionUtils.getCommandLine(reader));

    // load data
    try {
      data = reader.read();
    }
    catch (Exception e) {
      data   = new Vector<DataContainer>();
      result = "Error reading data: " + e;
      e.printStackTrace();
    }

    if (result == null) {
      manager = getDataContainerPanel().getContainerManager();
      cont = new Vector<Container>();
      for (i = 0; i < data.size(); i++)
        cont.add(manager.newContainer(data.get(i)));
      manager.addAll(cont);
    }
    showStatus("");

    return result;
  }
}
