/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * ArrayProducerConsumerTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.option;

import adams.core.io.PlaceholderFile;
import adams.core.option.ArrayConsumer;
import adams.core.option.ArrayProducer;

/**
 * Tests the ArrayProducer/Consumer classes.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public class ArrayProducerConsumerTest
  extends AbstractOptionProducerConsumerTestCase {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public ArrayProducerConsumerTest(String name) {
    super(name);
  }

  /**
   * Returns a default producer.
   *
   * @return		the producer
   */
  protected AbstractOptionProducer getProducer() {
    return new ArrayProducer();
  }

  /**
   * Returns a default consumer.
   *
   * @return		the consumer
   */
  protected AbstractOptionConsumer getConsumer() {
    return new ArrayConsumer();
  }
}
