/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ArrayHistogramTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.data.statistics;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.data.statistics.ArrayHistogram.BinCalculation;
import adams.env.Environment;

/**
 * Tests the adams.data.statistics.ArrayHistogram class. Run from commandline with: <p/>
 * java adams.data.statistics.ArrayHistogramTest
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public class ArrayHistogramTest
  extends AbstractArrayStatisticTestCase<ArrayHistogram, Number> {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public ArrayHistogramTest(String name) {
    super(name);
  }

  /**
   * Returns the data used in the regression test.
   *
   * @return		the data
   */
  protected Number[][][] getRegressionInputData() {
    Number[][][]	result;

    result = new Number[][][]{
	{
	  {0.3371297086119933, 0.4794099969876668, 1.4372161642591572, -1.6974807919798258, -1.369400080725186, -0.46473948178195446, -0.11468734808038919, 0.28448195151568106, 1.8069633441235429, -0.37917525771228167, 1.6479278301606355, -0.05704197144840617, 0.12552606030191846, 0.41691443506309067, -1.0742553446751197, -0.46045055413063884, 0.8800181178752691, 0.3263752445420184, -0.24337554288742866, -0.34647085864629934, 0.8074243748245418, -0.7117161301691409, 0.25890998974443796, -0.29407392217354184, 1.6694399826604285, 0.6814434907591344, -0.6374433506723575, 0.9084166233128561, -1.3332116227106707, -0.8869810958751353, -1.0703099527827038, 0.28714666276250905, -0.3508601789890628, 0.20675054135545481, 0.6088548428259745, 0.38019159600387065, 1.9660925763606063, 0.6605503315742836, 0.8298157638873118, -0.8132702111473743, 0.6541069285273823, 0.12547037181663198, 0.009704048898679802, 1.848305405510045, 1.8718825510847872, 1.2298313062375175, -1.0559218155665353, 1.1515213613303172, 1.7120551581601224, 0.10645257576734395, -0.2065483245135369, 0.05812787098227393, -0.17875365925209827, 0.522797814602974, -1.75940426726517, 1.2023094560634047, -0.13157984076991225, 0.7426878681416004, -0.9009509309685304, 0.12192262224247954, 2.1410991572999345, -0.9924764377679178, 1.2065449079031374, 0.2843210558704707, -0.7196284047314192, -0.017018544126024906, 1.2745444370674144, 0.44784222450786243, 0.2383216767962193, 0.4460070659067164, -0.12704199771617064, 1.007018962447426, 1.9326396278275209, -0.06281025182926546, 0.6043529376421659, -1.5071455133333438, 0.3881658159895973, 0.3502285678007563, 0.4363436586954699, 1.2543101535291534, -0.3736571998587513, 0.7955453690355886, -1.7787484667312792, 0.08492634157465256, 0.19567490200784252, 1.3614026578770089, 1.6473625072484313, 0.02100652073093179, 0.08094190125138784, -0.6149071985230199, 0.6410634038759503, -0.7396018960905382, -1.759077011198782, -0.054031834002816845, -0.801883507938359, -0.10421167260114236, 0.1768154717347627, 0.9873743622755439, -0.9135248051343056, -1.2844629954088935}
	},
	{
	  {0.3371297086119933, 0.4794099969876668, 1.4372161642591572, -1.6974807919798258, -1.369400080725186, -0.46473948178195446, -0.11468734808038919, 0.28448195151568106, 1.8069633441235429, -0.37917525771228167, 1.6479278301606355, -0.05704197144840617, 0.12552606030191846, 0.41691443506309067, -1.0742553446751197, -0.46045055413063884, 0.8800181178752691, 0.3263752445420184, -0.24337554288742866, -0.34647085864629934, 0.8074243748245418, -0.7117161301691409, 0.25890998974443796, -0.29407392217354184, 1.6694399826604285, 0.6814434907591344, -0.6374433506723575, 0.9084166233128561, -1.3332116227106707, -0.8869810958751353, -1.0703099527827038, 0.28714666276250905, -0.3508601789890628, 0.20675054135545481, 0.6088548428259745, 0.38019159600387065, 1.9660925763606063, 0.6605503315742836, 0.8298157638873118, -0.8132702111473743, 0.6541069285273823, 0.12547037181663198, 0.009704048898679802, 1.848305405510045, 1.8718825510847872, 1.2298313062375175, -1.0559218155665353, 1.1515213613303172, 1.7120551581601224, 0.10645257576734395, -0.2065483245135369, 0.05812787098227393, -0.17875365925209827, 0.522797814602974, -1.75940426726517, 1.2023094560634047, -0.13157984076991225, 0.7426878681416004, -0.9009509309685304, 0.12192262224247954, 2.1410991572999345, -0.9924764377679178, 1.2065449079031374, 0.2843210558704707, -0.7196284047314192, -0.017018544126024906, 1.2745444370674144, 0.44784222450786243, 0.2383216767962193, 0.4460070659067164, -0.12704199771617064, 1.007018962447426, 1.9326396278275209, -0.06281025182926546, 0.6043529376421659, -1.5071455133333438, 0.3881658159895973, 0.3502285678007563, 0.4363436586954699, 1.2543101535291534, -0.3736571998587513, 0.7955453690355886, -1.7787484667312792, 0.08492634157465256, 0.19567490200784252, 1.3614026578770089, 1.6473625072484313, 0.02100652073093179, 0.08094190125138784, -0.6149071985230199, 0.6410634038759503, -0.7396018960905382, -1.759077011198782, -0.054031834002816845, -0.801883507938359, -0.10421167260114236, 0.1768154717347627, 0.9873743622755439, -0.9135248051343056, -1.2844629954088935}
	},
	{
	  {0.3371297086119933, 0.4794099969876668, 1.4372161642591572, -1.6974807919798258, -1.369400080725186, -0.46473948178195446, -0.11468734808038919, 0.28448195151568106, 1.8069633441235429, -0.37917525771228167, 1.6479278301606355, -0.05704197144840617, 0.12552606030191846, 0.41691443506309067, -1.0742553446751197, -0.46045055413063884, 0.8800181178752691, 0.3263752445420184, -0.24337554288742866, -0.34647085864629934, 0.8074243748245418, -0.7117161301691409, 0.25890998974443796, -0.29407392217354184, 1.6694399826604285, 0.6814434907591344, -0.6374433506723575, 0.9084166233128561, -1.3332116227106707, -0.8869810958751353, -1.0703099527827038, 0.28714666276250905, -0.3508601789890628, 0.20675054135545481, 0.6088548428259745, 0.38019159600387065, 1.9660925763606063, 0.6605503315742836, 0.8298157638873118, -0.8132702111473743, 0.6541069285273823, 0.12547037181663198, 0.009704048898679802, 1.848305405510045, 1.8718825510847872, 1.2298313062375175, -1.0559218155665353, 1.1515213613303172, 1.7120551581601224, 0.10645257576734395, -0.2065483245135369, 0.05812787098227393, -0.17875365925209827, 0.522797814602974, -1.75940426726517, 1.2023094560634047, -0.13157984076991225, 0.7426878681416004, -0.9009509309685304, 0.12192262224247954, 2.1410991572999345, -0.9924764377679178, 1.2065449079031374, 0.2843210558704707, -0.7196284047314192, -0.017018544126024906, 1.2745444370674144, 0.44784222450786243, 0.2383216767962193, 0.4460070659067164, -0.12704199771617064, 1.007018962447426, 1.9326396278275209, -0.06281025182926546, 0.6043529376421659, -1.5071455133333438, 0.3881658159895973, 0.3502285678007563, 0.4363436586954699, 1.2543101535291534, -0.3736571998587513, 0.7955453690355886, -1.7787484667312792, 0.08492634157465256, 0.19567490200784252, 1.3614026578770089, 1.6473625072484313, 0.02100652073093179, 0.08094190125138784, -0.6149071985230199, 0.6410634038759503, -0.7396018960905382, -1.759077011198782, -0.054031834002816845, -0.801883507938359, -0.10421167260114236, 0.1768154717347627, 0.9873743622755439, -0.9135248051343056, -1.2844629954088935}
	},
	{
	  {0.3371297086119933, 0.4794099969876668, 1.4372161642591572, -1.6974807919798258, -1.369400080725186, -0.46473948178195446, -0.11468734808038919, 0.28448195151568106, 1.8069633441235429, -0.37917525771228167, 1.6479278301606355, -0.05704197144840617, 0.12552606030191846, 0.41691443506309067, -1.0742553446751197, -0.46045055413063884, 0.8800181178752691, 0.3263752445420184, -0.24337554288742866, -0.34647085864629934, 0.8074243748245418, -0.7117161301691409, 0.25890998974443796, -0.29407392217354184, 1.6694399826604285, 0.6814434907591344, -0.6374433506723575, 0.9084166233128561, -1.3332116227106707, -0.8869810958751353, -1.0703099527827038, 0.28714666276250905, -0.3508601789890628, 0.20675054135545481, 0.6088548428259745, 0.38019159600387065, 1.9660925763606063, 0.6605503315742836, 0.8298157638873118, -0.8132702111473743, 0.6541069285273823, 0.12547037181663198, 0.009704048898679802, 1.848305405510045, 1.8718825510847872, 1.2298313062375175, -1.0559218155665353, 1.1515213613303172, 1.7120551581601224, 0.10645257576734395, -0.2065483245135369, 0.05812787098227393, -0.17875365925209827, 0.522797814602974, -1.75940426726517, 1.2023094560634047, -0.13157984076991225, 0.7426878681416004, -0.9009509309685304, 0.12192262224247954, 2.1410991572999345, -0.9924764377679178, 1.2065449079031374, 0.2843210558704707, -0.7196284047314192, -0.017018544126024906, 1.2745444370674144, 0.44784222450786243, 0.2383216767962193, 0.4460070659067164, -0.12704199771617064, 1.007018962447426, 1.9326396278275209, -0.06281025182926546, 0.6043529376421659, -1.5071455133333438, 0.3881658159895973, 0.3502285678007563, 0.4363436586954699, 1.2543101535291534, -0.3736571998587513, 0.7955453690355886, -1.7787484667312792, 0.08492634157465256, 0.19567490200784252, 1.3614026578770089, 1.6473625072484313, 0.02100652073093179, 0.08094190125138784, -0.6149071985230199, 0.6410634038759503, -0.7396018960905382, -1.759077011198782, -0.054031834002816845, -0.801883507938359, -0.10421167260114236, 0.1768154717347627, 0.9873743622755439, -0.9135248051343056, -1.2844629954088935}
	},
	{
	  {0.3371297086119933, 0.4794099969876668, 1.4372161642591572, -1.6974807919798258, -1.369400080725186, -0.46473948178195446, -0.11468734808038919, 0.28448195151568106, 1.8069633441235429, -0.37917525771228167, 1.6479278301606355, -0.05704197144840617, 0.12552606030191846, 0.41691443506309067, -1.0742553446751197, -0.46045055413063884, 0.8800181178752691, 0.3263752445420184, -0.24337554288742866, -0.34647085864629934, 0.8074243748245418, -0.7117161301691409, 0.25890998974443796, -0.29407392217354184, 1.6694399826604285, 0.6814434907591344, -0.6374433506723575, 0.9084166233128561, -1.3332116227106707, -0.8869810958751353, -1.0703099527827038, 0.28714666276250905, -0.3508601789890628, 0.20675054135545481, 0.6088548428259745, 0.38019159600387065, 1.9660925763606063, 0.6605503315742836, 0.8298157638873118, -0.8132702111473743, 0.6541069285273823, 0.12547037181663198, 0.009704048898679802, 1.848305405510045, 1.8718825510847872, 1.2298313062375175, -1.0559218155665353, 1.1515213613303172, 1.7120551581601224, 0.10645257576734395, -0.2065483245135369, 0.05812787098227393, -0.17875365925209827, 0.522797814602974, -1.75940426726517, 1.2023094560634047, -0.13157984076991225, 0.7426878681416004, -0.9009509309685304, 0.12192262224247954, 2.1410991572999345, -0.9924764377679178, 1.2065449079031374, 0.2843210558704707, -0.7196284047314192, -0.017018544126024906, 1.2745444370674144, 0.44784222450786243, 0.2383216767962193, 0.4460070659067164, -0.12704199771617064, 1.007018962447426, 1.9326396278275209, -0.06281025182926546, 0.6043529376421659, -1.5071455133333438, 0.3881658159895973, 0.3502285678007563, 0.4363436586954699, 1.2543101535291534, -0.3736571998587513, 0.7955453690355886, -1.7787484667312792, 0.08492634157465256, 0.19567490200784252, 1.3614026578770089, 1.6473625072484313, 0.02100652073093179, 0.08094190125138784, -0.6149071985230199, 0.6410634038759503, -0.7396018960905382, -1.759077011198782, -0.054031834002816845, -0.801883507938359, -0.10421167260114236, 0.1768154717347627, 0.9873743622755439, -0.9135248051343056, -1.2844629954088935}
	},
	{
	  {0.3371297086119933, 0.4794099969876668, 1.4372161642591572, -1.6974807919798258, -1.369400080725186, -0.46473948178195446, -0.11468734808038919, 0.28448195151568106, 1.8069633441235429, -0.37917525771228167, 1.6479278301606355, -0.05704197144840617, 0.12552606030191846, 0.41691443506309067, -1.0742553446751197, -0.46045055413063884, 0.8800181178752691, 0.3263752445420184, -0.24337554288742866, -0.34647085864629934, 0.8074243748245418, -0.7117161301691409, 0.25890998974443796, -0.29407392217354184, 1.6694399826604285, 0.6814434907591344, -0.6374433506723575, 0.9084166233128561, -1.3332116227106707, -0.8869810958751353, -1.0703099527827038, 0.28714666276250905, -0.3508601789890628, 0.20675054135545481, 0.6088548428259745, 0.38019159600387065, 1.9660925763606063, 0.6605503315742836, 0.8298157638873118, -0.8132702111473743, 0.6541069285273823, 0.12547037181663198, 0.009704048898679802, 1.848305405510045, 1.8718825510847872, 1.2298313062375175, -1.0559218155665353, 1.1515213613303172, 1.7120551581601224, 0.10645257576734395, -0.2065483245135369, 0.05812787098227393, -0.17875365925209827, 0.522797814602974, -1.75940426726517, 1.2023094560634047, -0.13157984076991225, 0.7426878681416004, -0.9009509309685304, 0.12192262224247954, 2.1410991572999345, -0.9924764377679178, 1.2065449079031374, 0.2843210558704707, -0.7196284047314192, -0.017018544126024906, 1.2745444370674144, 0.44784222450786243, 0.2383216767962193, 0.4460070659067164, -0.12704199771617064, 1.007018962447426, 1.9326396278275209, -0.06281025182926546, 0.6043529376421659, -1.5071455133333438, 0.3881658159895973, 0.3502285678007563, 0.4363436586954699, 1.2543101535291534, -0.3736571998587513, 0.7955453690355886, -1.7787484667312792, 0.08492634157465256, 0.19567490200784252, 1.3614026578770089, 1.6473625072484313, 0.02100652073093179, 0.08094190125138784, -0.6149071985230199, 0.6410634038759503, -0.7396018960905382, -1.759077011198782, -0.054031834002816845, -0.801883507938359, -0.10421167260114236, 0.1768154717347627, 0.9873743622755439, -0.9135248051343056, -1.2844629954088935}
	}
    };

    return result;
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected ArrayHistogram[] getRegressionSetups() {
    ArrayHistogram[]	result;

    result = new ArrayHistogram[6];

    result[0] = new ArrayHistogram();

    result[1] = new ArrayHistogram();
    result[1].setBinCalculation(BinCalculation.MANUAL);
    result[1].setNumBins(25);

    result[2] = new ArrayHistogram();
    result[2].setBinCalculation(BinCalculation.DENSITY);
    result[2].setBinWidth(0.1);

    result[3] = new ArrayHistogram();
    result[3].setBinCalculation(BinCalculation.SCOTT);

    result[4] = new ArrayHistogram();
    result[4].setBinCalculation(BinCalculation.SQRT);

    result[5] = new ArrayHistogram();
    result[5].setBinCalculation(BinCalculation.STURGES);

    return result;
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(ArrayHistogramTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
