/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.Utils;
import adams.core.io.AbstractTextWriter;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.util.List;
import java.util.Vector;

public abstract class AbstractTextWriterTestCase
extends AdamsTestCase {
    public AbstractTextWriterTestCase(String name) {
        super(name);
    }

    @Override
    protected AbstractTestHelper newTestHelper() {
        return new TestHelper(this, "adams/core/io/data");
    }

    protected String process(String content, String name, AbstractTextWriter scheme) {
        String result;
        String filename = scheme.write(content, name);
        if (filename != null) {
            Vector lines = FileUtils.loadFromFile((File)new PlaceholderFile(filename));
            lines.add(0, "Filename: " + filename);
            lines.add(1, "---");
            result = Utils.flatten((List)lines, (String)"\n");
            FileUtils.delete((String)filename);
        } else {
            result = "No output generated";
        }
        return result;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract String[] getRegressionInputNames();

    protected abstract AbstractTextWriter[] getRegressionSetups();

    protected String load(String filename) {
        this.m_TestHelper.copyResourceToTmp(filename);
        Vector lines = FileUtils.loadFromFile((File)((Object)new TmpFile(filename)));
        String result = Utils.flatten((List)lines, (String)"\n");
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected boolean save(String data, String filename) {
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)data, (boolean)false);
    }

    protected String createOutputFilename(String input, int no) {
        String result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
            result = result + input.substring(index);
        }
        return result;
    }

    public void testRegression() {
        int i;
        String[] input = this.getRegressionInputFiles();
        String[] names = this.getRegressionInputNames();
        String[] output = new String[input.length];
        AbstractTextWriter[] setups = this.getRegressionSetups();
        AbstractTextWriterTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        AbstractTextWriterTestCase.assertEquals((String)"Number of files and names differ!", (int)input.length, (int)names.length);
        for (i = 0; i < input.length; ++i) {
            String data = this.load(input[i]);
            AbstractTextWriterTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), (Object)data);
            String processed = this.process(data, names[i], setups[i]);
            AbstractTextWriterTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i]);
            AbstractTextWriterTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractTextWriterTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

