/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.io.FileUtils;
import adams.env.Environment;
import adams.test.AdamsTestCase;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class FileUtilsTest
extends AdamsTestCase {
    public FileUtilsTest(String name) {
        super(name);
    }

    public void testQuoteExecutable() {
        String filename = "/usr/bin/ls";
        FileUtilsTest.assertEquals((String)"No quotes expected", (String)filename, (String)FileUtils.quoteExecutable((String)filename));
        filename = "C:\\Program files\\Blah\\funky.exe";
        FileUtilsTest.assertEquals((String)"Quotes expected", (String)("\"" + filename + "\""), (String)FileUtils.quoteExecutable((String)filename));
    }

    public void testGetExtension() {
        String filename = "hello.txt";
        FileUtilsTest.assertEquals((String)"Extensions differ", (String)"txt", (String)FileUtils.getExtension((String)filename));
        filename = "hello.props";
        FileUtilsTest.assertEquals((String)"Extensions differ", (String)"props", (String)FileUtils.getExtension((String)filename));
        filename = "/some/where/hello.props";
        FileUtilsTest.assertEquals((String)"Extensions differ", (String)"props", (String)FileUtils.getExtension((String)filename));
        filename = "/some/where/hello";
        FileUtilsTest.assertNull((String)"No extension available", (Object)FileUtils.getExtension((String)filename));
        filename = "/some/where/hello.tar.gz";
        FileUtilsTest.assertEquals((String)"Extensions differ", (String)"tar.gz", (String)FileUtils.getExtension((String)filename));
        File file = new File("hello.txt");
        FileUtilsTest.assertEquals((String)"Extensions differ", (String)"txt", (String)FileUtils.getExtension((File)file));
        file = new File("hello.props");
        FileUtilsTest.assertEquals((String)"Extensions differ", (String)"props", (String)FileUtils.getExtension((File)file));
        file = new File("/some/where/hello.props");
        FileUtilsTest.assertEquals((String)"Extensions differ", (String)"props", (String)FileUtils.getExtension((File)file));
        file = new File("/some/where/hello");
        FileUtilsTest.assertNull((String)"No extension available", (Object)FileUtils.getExtension((File)file));
        file = new File("/some/where/hello.tar.gz");
        FileUtilsTest.assertEquals((String)"Extensions differ", (String)"tar.gz", (String)FileUtils.getExtension((File)file));
    }

    public void testGetExtensions() {
        String filename = "hello.txt";
        FileUtilsTest.assertEquals((String)"# of Extensions differ", (int)1, (int)FileUtils.getExtensions((String)filename).length);
        FileUtilsTest.assertEquals((String)"Extension differs", (String)"txt", (String)FileUtils.getExtensions((String)filename)[0]);
        filename = "/some/where/hello.tar.gz";
        FileUtilsTest.assertEquals((String)"# of Extensions differ", (int)2, (int)FileUtils.getExtensions((String)filename).length);
        FileUtilsTest.assertEquals((String)"Extension differs", (String)"tar.gz", (String)FileUtils.getExtensions((String)filename)[0]);
        FileUtilsTest.assertEquals((String)"Extension differs", (String)"gz", (String)FileUtils.getExtensions((String)filename)[1]);
        File file = new File("hello.txt");
        FileUtilsTest.assertEquals((String)"# of Extensions differ", (int)1, (int)FileUtils.getExtensions((File)file).length);
        FileUtilsTest.assertEquals((String)"Extension differs", (String)"txt", (String)FileUtils.getExtensions((File)file)[0]);
        file = new File("/some/where/hello.tar.gz");
        FileUtilsTest.assertEquals((String)"# of Extensions differ", (int)2, (int)FileUtils.getExtensions((File)file).length);
        FileUtilsTest.assertEquals((String)"Extension differs", (String)"tar.gz", (String)FileUtils.getExtensions((File)file)[0]);
        FileUtilsTest.assertEquals((String)"Extension differs", (String)"gz", (String)FileUtils.getExtensions((File)file)[1]);
    }

    public static Test suite() {
        return new TestSuite(FileUtilsTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        FileUtilsTest.runTest(FileUtilsTest.suite());
    }
}

