/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.FileUtils;
import adams.data.statistics.AbstractArrayStatistic;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.io.Serializable;

public abstract class AbstractArrayStatisticTestCase<A extends AbstractArrayStatistic, D extends Serializable>
extends AdamsTestCase {
    public AbstractArrayStatisticTestCase(String name) {
        super(name);
    }

    @Override
    protected AbstractTestHelper newTestHelper() {
        return new TestHelper(this, "adams/data/statistic/data");
    }

    protected AbstractArrayStatistic.StatisticContainer process(D[][] data, A scheme) {
        scheme.clear();
        for (int i = 0; i < data.length; ++i) {
            scheme.add(data[i]);
        }
        return scheme.calculate();
    }

    protected abstract D[][][] getRegressionInputData();

    protected abstract A[] getRegressionSetups();

    protected boolean save(String data, String filename) {
        return FileUtils.writeToFile((String)(this.m_TestHelper.getTmpDirectory() + File.separator + filename), (Object)data, (boolean)false);
    }

    protected String createOutputFilename(int no) {
        return "out-" + no;
    }

    public void testRegression() {
        int i;
        Serializable[][][] data = this.getRegressionInputData();
        String[] output = new String[data.length];
        AbstractArrayStatistic[] setups = this.getRegressionSetups();
        AbstractArrayStatisticTestCase.assertEquals((String)"Number of data arrays and setups differ!", (int)data.length, (int)setups.length);
        for (i = 0; i < data.length; ++i) {
            String processed = this.process(data[i], setups[i]).toString();
            AbstractArrayStatisticTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            output[i] = this.createOutputFilename(i);
            boolean ok = this.save(processed, output[i]);
            AbstractArrayStatisticTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractArrayStatisticTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

