/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.condition.bool.Counting;
import adams.flow.control.Count;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.ForLoop;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class FlowTest
extends AbstractFlowTest {
    public FlowTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile_all.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_min.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_max.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_interval.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_min_max.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_min_max_interval.txt");
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile_all.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_min.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_max.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_interval.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_min_max.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_min_max_interval.txt");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        ForLoop fl = new ForLoop();
        fl.setLoopLower(1);
        fl.setLoopUpper(30);
        fl.setLoopStep(1);
        DumpFile df_all = new DumpFile();
        df_all.setAppend(true);
        df_all.setOutputFile((PlaceholderFile)new TmpFile("dumpfile_all.txt"));
        Count cvp_all = new Count();
        Counting cnt = new Counting();
        cvp_all.setCondition((AbstractBooleanCondition)cnt);
        cvp_all.add(0, (AbstractActor)df_all);
        DumpFile df_min = new DumpFile();
        df_min.setAppend(true);
        df_min.setOutputFile((PlaceholderFile)new TmpFile("dumpfile_min.txt"));
        Count cvp_min = new Count();
        cnt = new Counting();
        cnt.setMinimum(10);
        cvp_min.setCondition((AbstractBooleanCondition)cnt);
        cvp_min.add(0, (AbstractActor)df_min);
        DumpFile df_max = new DumpFile();
        df_max.setAppend(true);
        df_max.setOutputFile((PlaceholderFile)new TmpFile("dumpfile_max.txt"));
        Count cvp_max = new Count();
        cnt = new Counting();
        cnt.setMaximum(15);
        cvp_max.setCondition((AbstractBooleanCondition)cnt);
        cvp_max.add(0, (AbstractActor)df_max);
        DumpFile df_interval = new DumpFile();
        df_interval.setAppend(true);
        df_interval.setOutputFile((PlaceholderFile)new TmpFile("dumpfile_interval.txt"));
        Count cvp_interval = new Count();
        cnt = new Counting();
        cnt.setInterval(3);
        cvp_interval.setCondition((AbstractBooleanCondition)cnt);
        cvp_interval.add(0, (AbstractActor)df_interval);
        DumpFile df_min_max = new DumpFile();
        df_min_max.setAppend(true);
        df_min_max.setOutputFile((PlaceholderFile)new TmpFile("dumpfile_min_max.txt"));
        Count cvp_min_max = new Count();
        cnt = new Counting();
        cnt.setMinimum(5);
        cnt.setMaximum(23);
        cvp_min_max.setCondition((AbstractBooleanCondition)cnt);
        cvp_min_max.add(0, (AbstractActor)df_min_max);
        DumpFile df_min_max_interval = new DumpFile();
        df_min_max_interval.setAppend(true);
        df_min_max_interval.setOutputFile((PlaceholderFile)new TmpFile("dumpfile_min_max_interval.txt"));
        Count cvp_min_max_interval = new Count();
        cnt = new Counting();
        cnt.setMinimum(5);
        cnt.setMaximum(23);
        cnt.setInterval(3);
        cvp_min_max_interval.setCondition((AbstractBooleanCondition)cnt);
        cvp_min_max_interval.add(0, (AbstractActor)df_min_max_interval);
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{fl, cvp_all, cvp_min, cvp_max, cvp_interval, cvp_min_max, cvp_min_max_interval});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("dumpfile_all.txt"), new TmpFile("dumpfile_min.txt"), new TmpFile("dumpfile_max.txt"), new TmpFile("dumpfile_interval.txt"), new TmpFile("dumpfile_min_max.txt"), new TmpFile("dumpfile_min_max_interval.txt")});
    }

    public static Test suite() {
        return new TestSuite(FlowTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        FlowTest.runTest(FlowTest.suite());
    }
}

