/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.io.PlaceholderFile;
import adams.data.random.AbstractRandomNumberGenerator;
import adams.data.random.JavaRandomInt;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.condition.bool.Expression;
import adams.flow.control.Flow;
import adams.flow.control.Sinkhole;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.RandomNumberGenerator;
import adams.parser.BooleanExpressionText;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SinkholeTest
extends AbstractFlowTest {
    public SinkholeTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        RandomNumberGenerator rng = new RandomNumberGenerator();
        rng.setGenerator((AbstractRandomNumberGenerator)new JavaRandomInt());
        Expression cond = new Expression();
        cond.setExpression(new BooleanExpressionText("(X > 500)"));
        Sinkhole sh = new Sinkhole();
        sh.setCondition((AbstractBooleanCondition)cond);
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{rng, sh, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)((Object)new TmpFile("dumpfile.txt")));
    }

    public static Test suite() {
        return new TestSuite(SinkholeTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SinkholeTest.runTest(SinkholeTest.suite());
    }
}

