/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.sink.DumpFile;
import adams.flow.source.GlobalSource;
import adams.flow.source.StringConstants;
import adams.flow.standalone.GlobalActors;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class GlobalSourceTest
extends AbstractFlowTest {
    public GlobalSourceTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        StringConstants ids = new StringConstants();
        ids.setStrings(new BaseString[]{new BaseString("1"), new BaseString("2"), new BaseString("3")});
        ids.setName("ids");
        GlobalActors ga = new GlobalActors();
        ga.setActors(new AbstractActor[]{ids});
        GlobalSource gs = new GlobalSource();
        gs.setGlobalName(new GlobalActorReference("ids"));
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ga, gs, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)((Object)new TmpFile("dumpfile.txt")));
    }

    public static Test suite() {
        return new TestSuite(GlobalSourceTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        GlobalSourceTest.runTest(GlobalSourceTest.suite());
    }
}

