/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.control.Trigger;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.Start;
import adams.flow.source.StringConstants;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class StartTest
extends AbstractFlowTest {
    public StartTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        Start st = new Start();
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("1"), new BaseString("2"), new BaseString("3")});
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Trigger tr = new Trigger();
        tr.setActors(new AbstractActor[]{sc, df});
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{st, tr});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)((Object)new TmpFile("dumpfile.txt")));
    }

    public static Test suite() {
        return new TestSuite(StartTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        StartTest.runTest(StartTest.suite());
    }
}

