/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.Utils;
import adams.core.io.TextFileWriter;

public class TextFileWithLineNumbersWriter
extends TextFileWriter {
    private static final long serialVersionUID = 4958356636746933734L;
    protected String m_Separator;

    @Override
    public String globalInfo() {
        return "Writes the content to a text file, preceding each line with its line number.Makes sure that the filename is valid.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("separator", "separator", "");
    }

    public void setSeparator(String value) {
        this.m_Separator = value;
        this.reset();
    }

    public String getSeparator() {
        return this.m_Separator;
    }

    public String separatorTipText() {
        return "The separator between line number and line content.";
    }

    @Override
    public String write(String content, String name) {
        String[] lines = content.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = i + 1 + this.m_Separator + lines[i];
        }
        return super.write(Utils.flatten(lines, "\n"), name);
    }
}

