/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.docbook;

import adams.doc.docbook.AbstractComplexElement;
import adams.doc.docbook.DefaultComplexElement;
import adams.doc.docbook.DefaultSimpleElement;

public class InformalTable
extends AbstractComplexElement {
    private static final long serialVersionUID = -1301634257381722080L;
    protected AbstractComplexElement m_Head;
    protected AbstractComplexElement m_Body;
    protected int m_NumCols;

    public InformalTable(int numCols) {
        super("informaltable");
        this.m_NumCols = numCols;
        DefaultComplexElement tgroup = new DefaultComplexElement("tgroup");
        tgroup.setAttribute("cols", "" + numCols);
        this.add(tgroup);
        this.m_Head = null;
        this.m_Body = new DefaultComplexElement("tbody");
        tgroup.add(this.m_Body);
    }

    public InformalTable(String[] cells) {
        super("informaltable");
        this.m_NumCols = cells.length;
        DefaultComplexElement tgroup = new DefaultComplexElement("tgroup");
        tgroup.setAttribute("cols", "" + cells.length);
        this.add(tgroup);
        this.m_Head = new DefaultComplexElement("thead");
        tgroup.add(this.m_Head);
        this.m_Body = new DefaultComplexElement("tbody");
        tgroup.add(this.m_Body);
        this.addRow(this.m_Head, cells);
    }

    public int getNumCols() {
        return this.m_NumCols;
    }

    public boolean hasHead() {
        return this.m_Head != null;
    }

    public AbstractComplexElement getHead() {
        return this.m_Head;
    }

    public AbstractComplexElement getBody() {
        return this.m_Body;
    }

    protected AbstractComplexElement addRow(AbstractComplexElement parent, String[] cells) {
        if (cells.length != this.m_NumCols) {
            throw new IllegalArgumentException("Number of columns differ (expected/actual): " + this.m_NumCols + " != " + cells.length);
        }
        DefaultComplexElement result = new DefaultComplexElement("row");
        parent.add(result);
        for (String cell : cells) {
            DefaultSimpleElement entry = new DefaultSimpleElement("entry", cell);
            result.add(entry);
        }
        return result;
    }

    public AbstractComplexElement addRow(String[] cells) {
        return this.addRow(this.getBody(), cells);
    }
}

