/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.Variables;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.parser.BooleanExpression;
import adams.parser.BooleanExpressionText;
import adams.parser.GrammarSupplier;
import java.util.HashMap;

public class Expression
extends AbstractBooleanCondition
implements GrammarSupplier {
    private static final long serialVersionUID = -9169161144858552052L;
    protected BooleanExpressionText m_Expression;

    @Override
    public String globalInfo() {
        return "Emulates an If-Then-Else construct. The 'Then' branch gets executed if the 'If' expression is 'true'.\nIn case of integer or double tokens that arrive at the input, these can be accessed in the expression via 'X'; string tokens can be accessed via expression '\"X\"' (surrounding double quotes are required).\n\nThe following grammar is used for evaluating the boolean expressions:\n\n" + this.getGrammar();
    }

    @Override
    public String getGrammar() {
        return new BooleanExpression().getGrammar();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("expression", "expression", new BooleanExpressionText("true"));
    }

    public void setExpression(BooleanExpressionText value) {
        if (Variables.isPlaceholder(value.getValue())) {
            value = new BooleanExpressionText("(" + value.getValue() + ")");
        }
        this.m_Expression = value;
        this.reset();
    }

    public BooleanExpressionText getExpression() {
        return this.m_Expression;
    }

    public String expressionTipText() {
        return "The expression to evaluate - only as long as it evaluates to 'true' the loop actors get executed; expressions that consists solely of a variable (eg '@{blah}') get automatically wrapped in parentheses, since the expression string gets interpreted as attached variable instead.";
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("expression");
        if (variable != null) {
            return variable;
        }
        if (this.m_Expression != null && this.m_Expression.getValue().length() > 0) {
            return this.m_Expression.stringValue();
        }
        return null;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public String setUp() {
        String result = null;
        if (this.m_Expression == null || this.m_Expression.getValue().length() == 0) {
            result = "No expression provided!";
        }
        return result;
    }

    @Override
    protected boolean doEvaluate(AbstractActor owner, Token token) {
        boolean result;
        String exp = owner.getVariables().expand(this.getExpression().getValue());
        boolean hasString = exp.indexOf("\"X\"") > -1;
        HashMap<String, Double> symbols = new HashMap<String, Double>();
        Report report = null;
        if (token != null) {
            if (token.getPayload() instanceof Integer) {
                symbols.put("X", ((Integer)token.getPayload()).doubleValue());
            } else if (token.getPayload() instanceof Double) {
                symbols.put("X", (Double)token.getPayload());
            } else if (token.getPayload() instanceof String && hasString) {
                exp = exp.replace("\"X\"", "\"" + token.getPayload() + "\"");
            } else if (token.getPayload() instanceof Report) {
                report = (Report)token.getPayload();
            } else if (token.getPayload() instanceof ReportHandler) {
                report = ((ReportHandler)token.getPayload()).getReport();
            }
        }
        try {
            result = report != null ? BooleanExpression.evaluate(exp, report) : BooleanExpression.evaluate(exp, symbols);
            if (this.getDebugLevel() >= 2) {
                this.debug("exp: " + this.getExpression() + "\n" + "  --> " + exp + "\n" + "  = " + result, 2);
            }
        }
        catch (Exception e) {
            this.getSystemErr().println("Error evaluating boolean expression: " + exp);
            this.getSystemErr().printStackTrace(e);
            result = false;
        }
        return result;
    }
}

