/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.LogEntryWriter;
import adams.db.LogEntry;
import adams.flow.sink.AbstractFileWriter;
import java.util.Hashtable;

public class LogDumper
extends AbstractFileWriter {
    private static final long serialVersionUID = 2371387253627286951L;
    public static final String BACKUP_LOGGINGSTARTED = "logging started";
    protected boolean m_LoggingStarted;

    @Override
    public String globalInfo() {
        return "Actor that stores LogEntry objects in a file (CSV format).";
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_LoggingStarted = false;
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_LOGGINGSTARTED);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_LoggingStarted) {
            result.put(BACKUP_LOGGINGSTARTED, this.m_LoggingStarted);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_LOGGINGSTARTED)) {
            this.m_LoggingStarted = (Boolean)state.get(BACKUP_LOGGINGSTARTED);
            state.remove(BACKUP_LOGGINGSTARTED);
        }
        super.restoreState(state);
    }

    @Override
    public Class[] accepts() {
        return new Class[]{LogEntry.class};
    }

    @Override
    public String outputFileTipText() {
        return "The file store the log entries in.";
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (!this.m_LoggingStarted) {
            if (!LogEntryWriter.rewrite(this.m_OutputFile.getAbsolutePath())) {
                result = "Failed to start log file '" + this.m_OutputFile + "'!";
            } else {
                this.m_LoggingStarted = true;
            }
        }
        if (result == null) {
            LogEntry log = (LogEntry)this.m_InputToken.getPayload();
            if (!LogEntryWriter.write(this.m_OutputFile.getAbsolutePath(), log)) {
                result = "Failed to append log entry to '" + this.m_OutputFile + "'!";
            }
        }
        return result;
    }
}

