/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.template;

import adams.core.VariableName;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.flow.control.Tee;
import adams.flow.core.AbstractActor;
import adams.flow.template.AbstractActorTemplate;
import adams.flow.transformer.GetReportValue;
import adams.flow.transformer.SetVariable;

public class StoreReportValueInVariable
extends AbstractActorTemplate {
    private static final long serialVersionUID = 2310015199489870240L;
    protected Field m_Field;
    protected VariableName m_VariableName;

    @Override
    public String globalInfo() {
        return "Generates a sub-flow (enlosed by a Tee) that sets the value of a variable with the associated value from the report.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("field", "field", new Field("blah", DataType.NUMERIC));
        this.m_OptionManager.add("variable", "variableName", new VariableName());
    }

    public void setField(Field value) {
        this.m_Field = value;
        this.reset();
    }

    public Field getField() {
        return this.m_Field;
    }

    public String fieldTipText() {
        return "The report field to retrieve.";
    }

    public void setVariableName(VariableName value) {
        this.m_VariableName = value;
        this.reset();
    }

    public VariableName getVariableName() {
        return this.m_VariableName;
    }

    public String variableNameTipText() {
        return "The variable to store the report value in.";
    }

    @Override
    protected AbstractActor doGenerate() {
        Tee result = new Tee();
        result.setName("Setting " + this.m_VariableName);
        GetReportValue getValue = new GetReportValue();
        getValue.setField(this.m_Field);
        SetVariable setVar = new SetVariable();
        setVar.setVariableName((VariableName)this.m_VariableName.getClone());
        result.setActors(new AbstractActor[]{getValue, setVar});
        return result;
    }
}

