/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.objecttree;

import adams.gui.core.BaseTree;
import adams.gui.visualization.debug.inspectionhandler.AbstractInspectionHandler;
import adams.gui.visualization.debug.objecttree.Node;
import adams.gui.visualization.debug.objecttree.Renderer;
import adams.gui.visualization.debug.propertyextractor.AbstractPropertyExtractor;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.tree.DefaultTreeModel;

public class Tree
extends BaseTree {
    private static final long serialVersionUID = -127345486742553561L;
    protected Tree m_Self = this;
    protected transient Object m_Object;
    protected HashSet<Object> m_Inspected;

    public Tree() {
        this.setShowsRootHandles(true);
        this.setRootVisible(true);
        this.setCellRenderer(new Renderer());
        this.buildTree(null);
    }

    protected void buildTree(Object root) {
        DefaultTreeModel model;
        this.m_Inspected = new HashSet();
        if (root == null) {
            model = new DefaultTreeModel(null);
        } else {
            Node rootNode = this.buildTree(null, null, root, Node.NodeType.NORMAL);
            model = new DefaultTreeModel(rootNode);
        }
        this.m_Inspected.clear();
        this.setModel(model);
    }

    protected void addArray(Node parent, Object obj) {
        int len = Array.getLength(obj);
        for (int i = 0; i < len; ++i) {
            Object value = Array.get(obj, i);
            this.buildTree(parent, "[" + (i + 1) + "]", value, Node.NodeType.ARRAY_ELEMENT);
        }
    }

    protected boolean isPrimitive(Object obj) {
        if (obj instanceof Boolean) {
            return true;
        }
        if (obj instanceof Byte) {
            return true;
        }
        if (obj instanceof Short) {
            return true;
        }
        if (obj instanceof Integer) {
            return true;
        }
        if (obj instanceof Long) {
            return true;
        }
        if (obj instanceof Float) {
            return true;
        }
        if (obj instanceof Double) {
            return true;
        }
        if (obj instanceof Character) {
            return true;
        }
        return obj instanceof String;
    }

    protected Node buildTree(Node parent, String property, Object obj, Node.NodeType type) {
        Node result = new Node(property, obj, type);
        if (parent != null) {
            parent.add(result);
        }
        this.m_Inspected.add(obj);
        if (!this.isPrimitive(obj)) {
            result.add(new Node("hashCode", obj.hashCode(), Node.NodeType.HASHCODE));
        }
        if (obj.getClass().isArray()) {
            this.addArray(result, obj);
        }
        try {
            AbstractPropertyExtractor extractor = AbstractPropertyExtractor.getExtractor(obj);
            extractor.setCurrent(obj);
            for (int i = 0; i < extractor.size(); ++i) {
                Object current = extractor.getValue(i);
                if (current == null) continue;
                String label = extractor.getLabel(i);
                this.buildTree(result, label, current, Node.NodeType.NORMAL);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to obtain property descriptors for: " + obj);
            e.printStackTrace();
        }
        AbstractInspectionHandler inspection = AbstractInspectionHandler.getHandler(obj);
        Hashtable<String, Object> additional = inspection.inspect(obj);
        for (String key : additional.keySet()) {
            this.buildTree(result, key, additional.get(key), Node.NodeType.NORMAL);
        }
        return result;
    }

    public void setObject(Object value) {
        this.m_Object = value;
        this.buildTree(this.m_Object);
    }

    public Object getObject() {
        return this.m_Object;
    }
}

