/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.report.reportfactory;

import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Report;
import adams.db.ReportProvider;
import adams.gui.visualization.report.ReportFactory;
import adams.gui.visualization.report.reportfactory.AbstractTableActionWithDatabaseAccess;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

public class DatabaseModifyValue
extends AbstractTableActionWithDatabaseAccess {
    private static final long serialVersionUID = -8462082833012930410L;

    public DatabaseModifyValue() {
        super("Modify");
    }

    @Override
    protected void setFields(AbstractField[] value) {
        super.setFields(value);
        if (this.getFields().length == 0 && this.getFields()[0].getDataType() == DataType.BOOLEAN) {
            this.setName("Toggle '" + this.getFields()[0].toDisplayString() + "'");
        } else {
            this.setName(DatabaseModifyValue.createName("Modify '", value, 50));
        }
    }

    @Override
    public boolean isApplicable(ReportFactory.Table table, int row, AbstractField field, String value) {
        boolean result = super.isApplicable(table, row, field, value);
        if (result) {
            switch (field.getDataType()) {
                case BOOLEAN: {
                    result = this.parseBoolean(value) != null;
                    break;
                }
                case NUMERIC: {
                    result = this.parseDouble(value) != null;
                }
            }
        }
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportProvider provider = this.getReportProvider();
        Report report = this.getReport();
        boolean modified = false;
        block5: for (int i = 0; i < this.getFields().length; ++i) {
            AbstractField field = this.getFields()[i];
            String value = this.getValues()[i];
            switch (field.getDataType()) {
                case BOOLEAN: {
                    report.setValue(field, this.parseBoolean(value) == false);
                    modified = true;
                    continue block5;
                }
                case NUMERIC: {
                    String newValue;
                    Double valueDbl = this.parseDouble(value);
                    if (valueDbl == null) {
                        valueDbl = 0.0;
                    }
                    String valueInit = valueDbl.toString();
                    do {
                        if ((newValue = JOptionPane.showInputDialog("Enter numeric value for '" + field.toDisplayString() + "'", (Object)valueInit)) != null) continue;
                        return;
                    } while ((valueDbl = this.parseDouble(newValue)) == null);
                    report.setValue(field, valueDbl);
                    modified = true;
                    continue block5;
                }
                case STRING: {
                    String newValue = JOptionPane.showInputDialog("Enter value for '" + field.toDisplayString() + "'", (Object)value);
                    if (newValue == null) {
                        return;
                    }
                    report.setValue(field, newValue);
                    modified = true;
                    continue block5;
                }
                default: {
                    System.err.println(this.getClass().getName() + "/actionPerformed: unhandled data type '" + field.getDataType() + "'!");
                }
            }
        }
        if (modified) {
            provider.store(report.getDatabaseID(), report);
            this.setReport(report);
        }
    }
}

