/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * AbstractSimpleElement.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.doc.docbook;

/**
 * Ancestor for tags that have no children (only string content).
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public abstract class AbstractSimpleElement
  extends AbstractElement {

  /** for serialization. */
  private static final long serialVersionUID = -2865475570583425896L;

  /** the content. */
  protected String m_Content;

  /**
   * Initializes the element.
   *
   * @param tag		the name of the tag
   */
  public AbstractSimpleElement(String tag) {
    this(tag, "");
  }

  /**
   * Initializes the paragraph tag.
   *
   * @param tag		the name of the tag
   * @param content	the content of the tag
   */
  public AbstractSimpleElement(String tag, String content) {
    super(tag);
    setContent(content);
  }

  /**
   * Does not allow children.
   *
   * @param allows	ignored, always false
   */
  public void setAllowsChildren(boolean allows) {
    super.setAllowsChildren(false);
  }

  /**
   * Returns true if this node is allowed to have children.
   *
   * @return		always false
   */
  public boolean getAllowsChildren() {
    return false;
  }

  /**
   * Sets the content of the tag.
   *
   * @param value	the string content
   */
  public void setContent(String value) {
    if (value == null)
      value = "";
    m_Content = value;
  }

  /**
   * Returns the string content.
   *
   * @return		the content
   */
  public String getContent() {
    return m_Content;
  }

  /**
   * Returns whether no content is stored.
   *
   * @return		true if no content
   */
  public boolean isEmpty() {
    return (m_Content.length() == 0);
  }

  /**
   * Appends the content of the element to the buffer.
   *
   * @param buffer	the buffer to append the content to
   */
  protected void appendContent(StringBuilder buffer) {
    buffer.append(toEntities(m_Content));
  }
}
