/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.AbstractBaseObjectTestCase;
import adams.core.base.BaseRegExp;
import adams.env.Environment;
import junit.framework.Test;
import junit.framework.TestSuite;

public class BaseRegExpTest
extends AbstractBaseObjectTestCase<BaseRegExp> {
    public BaseRegExpTest(String name) {
        super(name);
    }

    @Override
    protected BaseRegExp getDefault() {
        return new BaseRegExp();
    }

    @Override
    protected BaseRegExp getCustom(String s) {
        return new BaseRegExp(s);
    }

    @Override
    protected String getTypicalValue() {
        return ".*";
    }

    public void testInvalidRegExp() {
        String expr = "(";
        BaseRegExp b = new BaseRegExp(expr);
        BaseRegExpTest.assertFalse((String)"values don't differ", (boolean)expr.equals(b.getValue()));
    }

    public void testMatching() {
        String expr = "[Hh]ello.*";
        BaseRegExp b = new BaseRegExp(expr);
        BaseRegExpTest.assertTrue((String)"matching failed", (boolean)b.isMatch("Hello"));
        BaseRegExpTest.assertTrue((String)"matching failed", (boolean)b.isMatch("hello"));
        BaseRegExpTest.assertTrue((String)"matching failed", (boolean)b.isMatch("Hello world"));
        BaseRegExpTest.assertFalse((String)"matching failed", (boolean)b.isMatch("blah"));
    }

    public void testMatchAllCheck() {
        BaseRegExp b = new BaseRegExp(".*");
        BaseRegExpTest.assertTrue((boolean)b.isMatchAll());
        b = new BaseRegExp("blah");
        BaseRegExpTest.assertFalse((boolean)b.isMatchAll());
        b = new BaseRegExp("");
        BaseRegExpTest.assertFalse((boolean)b.isMatchAll());
    }

    public void testEmptyCheck() {
        BaseRegExp b = new BaseRegExp(".*");
        BaseRegExpTest.assertFalse((boolean)b.isEmpty());
        b = new BaseRegExp("blah");
        BaseRegExpTest.assertFalse((boolean)b.isEmpty());
        b = new BaseRegExp("");
        BaseRegExpTest.assertTrue((boolean)b.isEmpty());
    }

    public static Test suite() {
        return new TestSuite(BaseRegExpTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        BaseRegExpTest.runTest(BaseRegExpTest.suite());
    }
}

