/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.io.CsvSpreadSheetReader;
import adams.core.io.CsvSpreadSheetWriter;
import adams.core.io.SpreadSheet;
import adams.env.Environment;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetTest
extends AdamsTestCase {
    public SpreadSheetTest(String name) {
        super(name);
    }

    @Override
    protected AbstractTestHelper newTestHelper() {
        return new TestHelper(this, "adams/core/io/data");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("sample.csv");
        this.m_TestHelper.copyResourceToTmp("sample2.csv");
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("sample.csv");
        this.m_TestHelper.deleteFileFromTmp("sample2.csv");
        super.tearDown();
    }

    public void testRead() {
        SpreadSheet sheet = new CsvSpreadSheetReader().read(new TmpFile("sample.csv").getAbsolutePath());
        SpreadSheetTest.assertEquals((String)"# of columns differ", (int)3, (int)sheet.getColumnCount());
        SpreadSheetTest.assertEquals((String)"# of rows differ", (int)16, (int)sheet.getRowCount());
    }

    public void testCellPositions() {
        int row = 0;
        int col = 0;
        String pos = SpreadSheet.getCellPosition((int)row, (int)col);
        SpreadSheetTest.assertEquals((String)"position differs", (String)"A1", (String)pos);
        row = 1;
        col = 2;
        pos = SpreadSheet.getCellPosition((int)row, (int)col);
        SpreadSheetTest.assertEquals((String)"position differs", (String)"C2", (String)pos);
        row = 1;
        col = 25;
        pos = SpreadSheet.getCellPosition((int)row, (int)col);
        SpreadSheetTest.assertEquals((String)"position differs", (String)"Z2", (String)pos);
        row = 1;
        col = 26;
        pos = SpreadSheet.getCellPosition((int)row, (int)col);
        SpreadSheetTest.assertEquals((String)"position differs", (String)"AA2", (String)pos);
        row = 2;
        col = 51;
        pos = SpreadSheet.getCellPosition((int)row, (int)col);
        SpreadSheetTest.assertEquals((String)"position differs", (String)"AZ3", (String)pos);
        row = 2;
        col = 52;
        pos = SpreadSheet.getCellPosition((int)row, (int)col);
        SpreadSheetTest.assertEquals((String)"position differs", (String)"BA3", (String)pos);
        row = 2;
        col = 701;
        pos = SpreadSheet.getCellPosition((int)row, (int)col);
        SpreadSheetTest.assertEquals((String)"position differs", (String)"ZZ3", (String)pos);
        row = 2;
        col = 702;
        pos = SpreadSheet.getCellPosition((int)row, (int)col);
        SpreadSheetTest.assertEquals((String)"position differs", (String)"AAA3", (String)pos);
        row = 20;
        col = 900;
        pos = SpreadSheet.getCellPosition((int)row, (int)col);
        SpreadSheetTest.assertEquals((String)"position differs", (String)"AHQ21", (String)pos);
        row = 23;
        col = 1000;
        pos = SpreadSheet.getCellPosition((int)row, (int)col);
        SpreadSheetTest.assertEquals((String)"position differs", (String)"ALM24", (String)pos);
    }

    public void testRegression() {
        SpreadSheet sheet = new CsvSpreadSheetReader().read(new TmpFile("sample.csv").getAbsolutePath());
        TmpFile output = new TmpFile("sample_out.csv");
        new CsvSpreadSheetWriter().write(sheet, ((File)((Object)output)).getAbsolutePath());
        String regression = this.m_Regression.compare(new File[]{((File)((Object)output)).getAbsoluteFile()});
        SpreadSheetTest.assertNull((String)("Output differs:\n" + regression), (Object)regression);
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetTest.runTest(SpreadSheetTest.suite());
    }
}

