/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOptionProducerTestCase;
import adams.core.option.FlowStructureGraphMLProducer;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.LowerCase;
import adams.flow.control.Flow;
import adams.flow.control.Tee;
import adams.flow.core.AbstractActor;
import adams.flow.sink.Display;
import adams.flow.sink.DumpFile;
import adams.flow.sink.Null;
import adams.flow.source.SingleFileSupplier;
import adams.flow.transformer.Convert;
import adams.flow.transformer.TextFileReader;

public class FlowStructureGraphMLProducerTest
extends AbstractOptionProducerTestCase {
    public FlowStructureGraphMLProducerTest(String name) {
        super(name);
    }

    public void testSimple() {
        DumpFile handler = new DumpFile();
        handler.setDebugLevel(1);
        handler.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.csv"));
        handler.setAppend(true);
        this.m_OptionHandler = handler;
        FlowStructureGraphMLProducer producer = new FlowStructureGraphMLProducer();
        producer.produce((OptionHandler)handler);
        FlowStructureGraphMLProducerTest.assertEquals((String)"getOutput() differs", (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">\n  <key id=\"d0\" for=\"node\" attr.name=\"label\" attr.type=\"string\"/>\n  <graph id=\"adams\" edgedefault=\"directed\">\n  <node id=\"n1\">\n    <data key=\"d0\">DumpFile</data>\n  </node>\n  </graph>\n</graphml>\n", (String)("" + producer.getOutput()));
        FlowStructureGraphMLProducerTest.assertEquals((String)"toString() differs", (String)("" + producer.getOutput()), (String)producer.toString());
    }

    public void testComplex() {
        Flow flow = new Flow();
        try {
            AbstractArgumentOption argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("actors");
            AbstractActor[] tmp1 = new AbstractActor[4];
            SingleFileSupplier tmp2 = new SingleFileSupplier();
            argOption = (AbstractArgumentOption)tmp2.getOptionManager().findByProperty("file");
            tmp2.setFile((PlaceholderFile)argOption.valueOf("${CWD}/parsers.xml"));
            tmp1[0] = tmp2;
            TextFileReader tmp4 = new TextFileReader();
            argOption = (AbstractArgumentOption)tmp4.getOptionManager().findByProperty("outputType");
            tmp4.setOutputType((TextFileReader.OutputType)argOption.valueOf("SINGLE_STRING"));
            tmp1[1] = tmp4;
            Tee tmp6 = new Tee();
            argOption = (AbstractArgumentOption)tmp6.getOptionManager().findByProperty("actors");
            AbstractActor[] tmp7 = new AbstractActor[2];
            Convert tmp8 = new Convert();
            argOption = (AbstractArgumentOption)tmp8.getOptionManager().findByProperty("conversion");
            LowerCase tmp10 = new LowerCase();
            tmp8.setConversion((AbstractConversion)tmp10);
            tmp7[0] = tmp8;
            Null tmp11 = new Null();
            tmp7[1] = tmp11;
            tmp6.setActors(tmp7);
            tmp1[2] = tmp6;
            Display tmp12 = new Display();
            tmp1[3] = tmp12;
            flow.setActors(tmp1);
        }
        catch (Exception e) {
            FlowStructureGraphMLProducerTest.fail((String)("Set up of flow failed: " + e));
        }
        this.m_OptionHandler = flow;
        FlowStructureGraphMLProducer producer = new FlowStructureGraphMLProducer();
        producer.produce((OptionHandler)flow);
        FlowStructureGraphMLProducerTest.assertEquals((String)"getOutput() differs", (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">\n  <key id=\"d0\" for=\"node\" attr.name=\"label\" attr.type=\"string\"/>\n  <graph id=\"adams\" edgedefault=\"directed\">\n  <node id=\"n1\">\n    <data key=\"d0\">Flow</data>\n  </node>\n  <edge id=\"e1\" directed=\"true\" source=\"n1\" target=\"n2\"/>\n  <node id=\"n2\">\n    <data key=\"d0\">SingleFileSupplier</data>\n  </node>\n  <edge id=\"e2\" directed=\"true\" source=\"n1\" target=\"n3\"/>\n  <node id=\"n3\">\n    <data key=\"d0\">TextFileReader</data>\n  </node>\n  <edge id=\"e3\" directed=\"true\" source=\"n1\" target=\"n4\"/>\n  <node id=\"n4\">\n    <data key=\"d0\">Tee</data>\n  </node>\n  <edge id=\"e4\" directed=\"true\" source=\"n4\" target=\"n5\"/>\n  <node id=\"n5\">\n    <data key=\"d0\">Convert</data>\n  </node>\n  <edge id=\"e5\" directed=\"true\" source=\"n4\" target=\"n6\"/>\n  <node id=\"n6\">\n    <data key=\"d0\">Null</data>\n  </node>\n  <edge id=\"e6\" directed=\"true\" source=\"n1\" target=\"n7\"/>\n  <node id=\"n7\">\n    <data key=\"d0\">Display</data>\n  </node>\n  </graph>\n</graphml>\n", (String)("" + producer.getOutput()));
        FlowStructureGraphMLProducerTest.assertEquals((String)"toString() differs", (String)("" + producer.getOutput()), (String)producer.toString());
    }
}

