/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.io.PlaceholderFile;
import adams.data.random.AbstractRandomNumberGenerator;
import adams.data.random.JavaRandomInt;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.condition.bool.Expression;
import adams.flow.control.Flow;
import adams.flow.control.Switch;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.RandomNumberGenerator;
import adams.parser.BooleanExpressionText;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SwitchTest
extends AbstractFlowTest {
    public SwitchTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile-300.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile-600.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile-default.txt");
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile-300.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile-600.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile-default.txt");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        RandomNumberGenerator rng = new RandomNumberGenerator();
        rng.setGenerator((AbstractRandomNumberGenerator)new JavaRandomInt());
        DumpFile df300 = new DumpFile();
        df300.setAppend(true);
        df300.setOutputFile((PlaceholderFile)new TmpFile("dumpfile-300.txt"));
        DumpFile df600 = new DumpFile();
        df600.setAppend(true);
        df600.setOutputFile((PlaceholderFile)new TmpFile("dumpfile-600.txt"));
        DumpFile dfDef = new DumpFile();
        dfDef.setAppend(true);
        dfDef.setOutputFile((PlaceholderFile)new TmpFile("dumpfile-default.txt"));
        Expression exp300 = new Expression();
        exp300.setExpression(new BooleanExpressionText("X < 300"));
        Expression exp600 = new Expression();
        exp600.setExpression(new BooleanExpressionText("X < 600"));
        Switch sw = new Switch();
        sw.setConditions(new AbstractBooleanCondition[]{exp300, exp600});
        sw.setCases(new AbstractActor[]{df300, df600, dfDef});
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{rng, sw});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("dumpfile-300.txt"), new TmpFile("dumpfile-600.txt"), new TmpFile("dumpfile-default.txt")});
    }

    public static Test suite() {
        return new TestSuite(SwitchTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SwitchTest.runTest(SwitchTest.suite());
    }
}

