/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.base.BaseRegExp;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.management.OS;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.DirectoryLister;
import adams.flow.transformer.StringReplace;
import adams.test.TmpDirectory;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class DirectoryListerTest
extends AbstractFlowTest {
    public DirectoryListerTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("external_standalone.flow");
        this.m_TestHelper.copyResourceToTmp("external_source.flow");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        this.m_TestHelper.deleteFileFromTmp("external_standalone.flow");
        this.m_TestHelper.deleteFileFromTmp("external_source.flow");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        DirectoryLister dir = new DirectoryLister();
        dir.setWatchDir((PlaceholderDirectory)new TmpDirectory());
        dir.setListFiles(true);
        dir.setRegExp(new BaseRegExp("ext.*source.*flow"));
        StringReplace sr = new StringReplace();
        if (OS.isWindows()) {
            sr.setFind(new BaseRegExp(".*\\\\"));
        } else {
            sr.setFind(new BaseRegExp(".*\\/"));
        }
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{dir, sr, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)((Object)new TmpFile("dumpfile.txt")));
    }

    public static Test suite() {
        return new TestSuite(DirectoryListerTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        DirectoryListerTest.runTest(DirectoryListerTest.suite());
    }
}

