/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.MultiFileSupplier;
import adams.test.Platform;
import adams.test.TmpFile;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;

public class MultiFileSupplierTest
extends AbstractFlowTest {
    public MultiFileSupplierTest(String name) {
        super(name);
    }

    @Override
    protected HashSet<Platform> getPlatforms() {
        return new HashSet<Platform>(Arrays.asList(Platform.LINUX));
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        MultiFileSupplier sfs = new MultiFileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("vote.csv"), new TmpFile("labor.csv"), new TmpFile("blah.csv")});
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sfs, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)((Object)new TmpFile("dumpfile.txt")));
    }

    public static Test suite() {
        return new TestSuite(MultiFileSupplierTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        MultiFileSupplierTest.runTest(MultiFileSupplierTest.suite());
    }
}

