/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseString;
import adams.core.io.AbstractFilenameGenerator;
import adams.core.io.FixedFilenameGenerator;
import adams.core.io.PlaceholderDirectory;
import adams.data.io.input.AbstractReportReader;
import adams.data.io.input.DefaultSimpleReportReader;
import adams.data.io.output.AbstractReportWriter;
import adams.data.io.output.DefaultSimpleCSVReportWriter;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.source.StringConstants;
import adams.flow.transformer.ReportFileReader;
import adams.flow.transformer.ReportFileWriter;
import adams.test.TmpDirectory;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ReportFileReaderTest
extends AbstractFlowTest {
    public ReportFileReaderTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("simple.report");
        this.m_TestHelper.deleteFileFromTmp("out.csv");
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("out.csv");
        this.m_TestHelper.deleteFileFromTmp("simple.report");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("${TMP}/simple.report")});
        ReportFileReader fr = new ReportFileReader();
        fr.setReader((AbstractReportReader)new DefaultSimpleReportReader());
        DefaultSimpleCSVReportWriter writer = new DefaultSimpleCSVReportWriter();
        FixedFilenameGenerator ffg = new FixedFilenameGenerator();
        ffg.setDirectory((PlaceholderDirectory)new TmpDirectory());
        ffg.setName("out.csv");
        ReportFileWriter fw = new ReportFileWriter();
        fw.setFilenameGenerator((AbstractFilenameGenerator)ffg);
        fw.setWriter((AbstractReportWriter)writer);
        fw.setOutputDir(new PlaceholderDirectory(this.m_TestHelper.getTmpDirectory()));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sc, fr, fw});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("out.csv")});
    }

    public static Test suite() {
        return new TestSuite(ReportFileReaderTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ReportFileReaderTest.runTest(ReportFileReaderTest.suite());
    }
}

