/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseRegExp;
import adams.core.base.BaseString;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.sink.Null;
import adams.flow.source.StringConstants;
import adams.flow.transformer.StringMatcher;
import junit.framework.Test;
import junit.framework.TestSuite;

public class StringMatcherTest
extends AbstractFlowTest {
    public StringMatcherTest(String name) {
        super(name);
    }

    @Override
    public AbstractActor getActor() {
        StringConstants con = new StringConstants();
        con.setStrings(new BaseString[]{new BaseString("ABC"), new BaseString("DEF"), new BaseString("BCD"), new BaseString("CDE")});
        StringMatcher actor = new StringMatcher();
        actor.setRegExp(new BaseRegExp("^.*BC.*$"));
        Null nul = new Null();
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{con, actor, nul});
        return flow;
    }

    public void testActorDefaultMatching() {
        String[] strIn = new String[]{"ABC", "DEF", "BCD", "CDE"};
        String[] strOut = new String[]{"ABC", "BCD"};
        StringMatcher actor = new StringMatcher();
        actor.setRegExp(new BaseRegExp("^.*BC.*$"));
        StringMatcherTest.assertNull((String)"problem with setUp()", (Object)actor.setUp());
        actor.input(new Token((Object)strIn));
        StringMatcherTest.assertNull((String)"problem with execute()", (Object)actor.execute());
        Token out = actor.output();
        StringMatcherTest.assertNotNull((String)"problem with output()", (Object)out);
        String[] strOutActor = (String[])out.getPayload();
        StringMatcherTest.assertEquals((String)"array length differs", (int)strOut.length, (int)strOutActor.length);
        for (int i = 0; i < strOut.length; ++i) {
            StringMatcherTest.assertEquals((String)"values differ", (String)strOut[i], (String)strOutActor[i]);
        }
        actor.wrapUp();
        actor.cleanUp();
    }

    public void testActorInverseMatching() {
        String[] strIn = new String[]{"ABC", "DEF", "BCD", "CDE"};
        String[] strOut = new String[]{"DEF", "CDE"};
        StringMatcher actor = new StringMatcher();
        actor.setInvert(true);
        actor.setRegExp(new BaseRegExp("^.*BC.*$"));
        StringMatcherTest.assertNull((String)"problem with setUp()", (Object)actor.setUp());
        actor.input(new Token((Object)strIn));
        StringMatcherTest.assertNull((String)"problem with execute()", (Object)actor.execute());
        Token out = actor.output();
        StringMatcherTest.assertNotNull((String)"problem with output()", (Object)out);
        String[] strOutActor = (String[])out.getPayload();
        StringMatcherTest.assertEquals((String)"array length differs", (int)strOut.length, (int)strOutActor.length);
        for (int i = 0; i < strOut.length; ++i) {
            StringMatcherTest.assertEquals((String)"values differ", (String)strOut[i], (String)strOutActor[i]);
        }
        actor.wrapUp();
        actor.cleanUp();
    }

    public static Test suite() {
        return new TestSuite(StringMatcherTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        StringMatcherTest.runTest(StringMatcherTest.suite());
    }
}

