/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.env.Environment;
import adams.parser.AbstractExpressionEvaluatorTestCase;
import adams.parser.ReportMathExpression;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ReportMathExpressionTest
extends AbstractExpressionEvaluatorTestCase<Double, ReportMathExpression> {
    public ReportMathExpressionTest(String name) {
        super(name);
    }

    @Override
    protected String[][] getRegressionExpressions() {
        return new String[][]{{"1 + 2", "1 - 2", "3 * 2", "1 / 2", "2 ^ X", "abs(-10.4 + X)", "sqrt(X*1.3)", "log(X + 2)", "exp(3*100-2)", "sin(X)", "cos(X + 1.1)", "tan(X)", "rint(X)", "floor(X * 10)", "pow(3, X)", "ceil(X/2)", "ifelse(X < 0, X^2, X*2)", "1/sqrt(2*PI*pow(0.5,2))*exp(-pow(X-10,2)/(2*0.5))", "ifelse(X < 0, X, -X)", "(ifelse(X < 0, X, -X))", "ifelse((X < 0), X, -X)", "(2 ^ X)", "1/sqrt(2*PI*pow(1.0,2))*exp(-1*pow(X-0,2)/(2*1.0))", "10 % 3", "-2^2", "ifelse(1 != 1, 0, 1)", "ifelse(2 != 1, 0, 1)", "ifmissing(X, 0)", "ifmissing(Y, 0)", "ifelse(bool(T), 0, 1)", "ifelse(bool(F), 0, 1)", "ifelse(bool([This is true]), 0, 1)", "ifelse(bool([value\\tfalse]), 0, 1)"}};
    }

    protected ReportMathExpression[] getRegressionSetups() {
        Report report = new Report();
        report.setValue((AbstractField)new Field("X", DataType.NUMERIC), (Object)12.0);
        report.setValue((AbstractField)new Field("T", DataType.BOOLEAN), (Object)true);
        report.setValue((AbstractField)new Field("F", DataType.BOOLEAN), (Object)false);
        report.setValue((AbstractField)new Field("This is true", DataType.BOOLEAN), (Object)true);
        report.setValue((AbstractField)new Field("value\tfalse", DataType.BOOLEAN), (Object)false);
        ReportMathExpression[] result = new ReportMathExpression[]{new ReportMathExpression()};
        result[0].setReport(report);
        return result;
    }

    public static Test suite() {
        return new TestSuite(ReportMathExpressionTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ReportMathExpressionTest.runTest(ReportMathExpressionTest.suite());
    }
}

