/**
 * Debuggable.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.core;

/**
 * Interface for classes that support debugging output.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1626 $
 */
public interface Debuggable {

  /**
   * Sets the debugging level (0 = off).
   *
   * @param value 	>0 if debugging output should be printed
   */
  public void setDebugLevel(int value);

  /**
   * Returns the debugging level (0 = turned off).
   *
   * @return 		true if debugging output is on
   */
  public int getDebugLevel();
}
