/**
 * HtmlUtils.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.core.net;

import adams.core.Utils;

/**
 * Utility functions regarding HTML.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4081 $
 */
public class HtmlUtils {

  /**
   * Converts the given String into HTML, i.e., replacing some char entities
   * with HTML entities.
   *
   * @param s		the string to convert
   * @return		the HTML conform string
   */
  public static String toHTML(String s) {
    String	result;

    result = s;

    result = result.replaceAll("&", "&amp;");
    result = result.replaceAll("<", "&lt;");
    result = result.replaceAll(">", "&gt;");
    result = result.replaceAll("@", "&#64;");
    result = result.replaceAll("/", "&#47;");

    return result;
  }

  /**
   * Turns the string into HTML. Line feeds are automatically converted
   * into &lt;br&gt;.
   *
   * @param s		the string to convert to HTML
   * @param nbsp	whether to convert leading blanks to non-breaking spaces
   * @return		the HTML string
   * @see		toHTML(String)
   */
  public static String toHTML(String s, boolean nbsp) {
    String		result;
    String[]		lines;
    StringBuilder	newLine;
    int			i;
    int			n;
    boolean		first;

    result = toHTML(s);
    result = result.replace("\n", "<br>\n");

    if (nbsp) {
      lines = result.split("\n");
      for (i = 0; i < lines.length; i++) {
	first   = true;
	newLine = new StringBuilder();
	for (n = 0; n < lines[i].length(); n++) {
	  if (first) {
	    if (lines[i].charAt(n) == ' ') {
	      newLine.append("&#160;");
	    }
	    else {
	      first = false;
	      newLine.append(lines[i].charAt(n));
	    }
	  }
	  else {
	    newLine.append(lines[i].charAt(n));
	  }
	}
	lines[i] = newLine.toString();
      }
      result = Utils.flatten(lines, "\n");
    }

    return result;
  }

  /**
   * Converts some HTML entities with the corresponding characters.
   *
   * @param s		the HTML string to convert
   * @return		the converted string
   */
  public static String fromHTML(String s) {
    String	result;

    result = s;

    result = result.replaceAll("&lt;", "<");
    result = result.replaceAll("&gt;", ">");
    result = result.replaceAll("&#64;", "@");
    result = result.replaceAll("&#47;", "/");
    result = result.replaceAll("&amp;", "&");

    return result;
  }
}
