/*
 * MultiCondition.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.condition;


/**
 <!-- globalinfo-start -->
 * Checks multiple conditions. Stops checking when the first fails.
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D (property: debug)
 *         If set to true, scheme may output additional info to the console.
 * </pre>
 *
 * <pre>-condition &lt;adams.flow.condition.AbstractCondition&gt; [-condition ...] (property: subConditions)
 *         The conditions to check.
 * </pre>
 *
 <!-- options-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2391 $
 */
public class MultiCondition
  extends AbstractCondition {

  /** for serialization. */
  private static final long serialVersionUID = -3833261282991705L;

  /** the sub-conditions to check. */
  protected AbstractCondition[] m_Conditions;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return "Checks multiple conditions. Stops checking when the first fails.";
  }

  /**
   * Adds options to the internal list of options.
   */
  public void defineOptions() {
    super.defineOptions();

    m_OptionManager.add(
	    "condition", "subConditions",
	    new AbstractCondition[0]);
  }

  /**
   * Sets the conditions to use.
   *
   * @param value	the conditions
   */
  public void setSubConditions(AbstractCondition[] value) {
    m_Conditions = value;
  }

  /**
   * Returns the conditions to check.
   *
   * @return		the conditions
   */
  public AbstractCondition[] getSubConditions() {
    return m_Conditions;
  }

  /**
   * Returns the tip text for this property.
   *
   * @return 		tip text for this property suitable for
   * 			displaying in the gui
   */
  public String subConditionsTipText() {
    return "The conditions to check.";
  }

  /**
   * Performs the actual testing of the condition.
   *
   * @return		the test result, null if everything OK, otherwise
   * 			the error message
   */
  protected String performTest() {
    String	result;
    int		i;

    result = null;

    for (i = 0; i < m_Conditions.length; i++) {
      result = m_Conditions[i].getTestResult();
      if (result != null) {
	result = "Failed condition #" + (i+1) + ": " + result;
	break;
      }
    }

    return result;
  }
}
