/*
 * True.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.condition;

/**
 <!-- globalinfo-start -->
 * Dummy condition that always succeeds.
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 * 
 * <pre>-D (property: debug)
 *         If set to true, scheme may output additional info to the console.
 * </pre>
 * 
 <!-- options-end -->
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4 $
 */
public class True
  extends AbstractCondition {
  
  /** for serialization. */
  private static final long serialVersionUID = 5932299107060329344L;

  /**
   * Returns a string describing the object.
   * 
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return "Dummy condition that always succeeds.";
  }

  /**
   * Returns always null, i.e., the test succeeds.
   * 
   * @return		always null
   */
  protected String performTest() {
    return null;
  }
}
