/**
 * ModifyingProcessor.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.processor;

import adams.flow.core.AbstractActor;

/**
 * Interface for processors that potentially modify the actor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3482 $
 */
public interface ModifyingProcessor {

  /**
   * Returns whether the actor was modified.
   *
   * @return		true if the actor was modified
   */
  public boolean isModified();

  /**
   * Returns the modified actor.
   *
   * @return		the modified actor, null if not modified
   */
  public AbstractActor getModifiedActor();
}
