/*
 * AbstractDisplay.java
 * Copyright (C) 2009-2010 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.sink;

import adams.flow.core.InputConsumer;
import adams.flow.core.Token;

/**
 * Ancestor for actors that display stuff.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3685 $
 */
public abstract class AbstractDisplay
  extends adams.flow.core.AbstractDisplay
  implements InputConsumer {

  /** for serialization. */
  private static final long serialVersionUID = 8175993838879683118L;

  /**
   * Before the token is displayed.
   * <p/>
   * Default implementation does nothing.
   *
   * @param token	the token to display
   */
  protected void preDisplay(Token token) {
  }

  /**
   * Displays the token (the panel and dialog have already been created at
   * this stage).
   *
   * @param token	the token to display
   */
  protected abstract void display(Token token);

  /**
   * After the token has been displayed.
   * <p/>
   * Default implementation does nothing.
   *
   * @param token	the token to display
   */
  protected void postDisplay(Token token) {
  }

  /**
   * Returns a runnable that displays frame, etc.
   *
   * @return		the runnable
   */
  protected Runnable newDisplayRunnable() {
    Runnable	result;
    final Token	input;

    input  = m_InputToken;
    result = new Runnable() {
      public void run() {
	if (!m_Frame.isVisible())
	  m_Frame.setVisible(true);
	try {
	  preDisplay(input);
	  display(input);
	  postDisplay(input);
	}
	catch (Exception e) {
	  getSystemErr().println("Failed to display token " + input + ": ");
	  getSystemErr().printStackTrace(e);
	}
	m_InputToken = null;
	m_Updating   = false;
      }
    };

    return result;
  }
}
