/**
 * NoMarkers.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.sink.sequenceplotter;

import java.awt.Color;
import java.awt.Graphics;

import adams.data.sequence.XYSequence;

/**
 <!-- globalinfo-start -->
 * Dummy paintlet, since it doesn't draw anything. Useful when trying to avoid markers being drawn.
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D &lt;int&gt; (property: debugLevel)
 * &nbsp;&nbsp;&nbsp;The greater the number the more additional info the scheme may output to
 * &nbsp;&nbsp;&nbsp;the console (0 = off).
 * &nbsp;&nbsp;&nbsp;default: 0
 * &nbsp;&nbsp;&nbsp;minimum: 0
 * </pre>
 *
 * <pre>-stroke-thickness &lt;float&gt; (property: strokeThickness)
 * &nbsp;&nbsp;&nbsp;The thickness of the stroke.
 * &nbsp;&nbsp;&nbsp;default: 1.0
 * &nbsp;&nbsp;&nbsp;minimum: 0.01
 * </pre>
 *
 <!-- options-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3932 $
 */
public class NoMarkers
  extends AbstractMarkerPaintlet {

  /** for serialization. */
  private static final long serialVersionUID = -8460180392771251305L;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return
        "Dummy paintlet, since it doesn't draw anything. Useful when trying "
      + "to avoid markers being drawn.";
  }

  /**
   * Does nothing.
   *
   * @param g		the graphics context
   * @param data	the marker data to draw
   * @param color	the color to draw in
   */
  protected void drawData(Graphics g, XYSequence data, Color color) {
  }
}
